/*
 * Decompiled with CFR 0.152.
 */
package sora.bhc.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.common.Loader;

public class JsonHandler {
    public static List<String> genericValues = Arrays.asList("hostile", "boss", "dragon");
    private Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private JsonObject object = new JsonObject();
    private String name;

    public JsonHandler(String name) {
        this.name = name;
    }

    public JsonObject getObject() {
        return this.object;
    }

    public void addObject(String category, String name, double value) {
        this.object.getAsJsonObject(category).addProperty(name, (Number)value);
    }

    public void addCategory(String ... categories) {
        for (String string : categories) {
            this.object.add(string, (JsonElement)new JsonObject());
        }
    }

    public void saveJson() {
        File file = new File(Loader.instance().getConfigDir().getPath() + "/bhc/" + this.name);
        JsonParser parser = new JsonParser();
        try {
            if (file.exists()) {
                this.object = parser.parse((Reader)new FileReader(file)).getAsJsonObject();
                return;
            }
            FileWriter writer = new FileWriter(file);
            this.gson.toJson((JsonElement)this.object, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

