/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.util;

import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.util.BlockPlaceResult;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StructureBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class PlayerInteractionUtil {
    public static boolean tryHarvestBlock(ServerPlayerEntity player, World world, BlockPos pos) {
        boolean flag1;
        int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (ServerPlayerEntity)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        BlockState iblockstate = world.func_180495_p(pos);
        TileEntity tileentity = world.func_175625_s(pos);
        Block block = iblockstate.func_177230_c();
        if ((block instanceof CommandBlockBlock || block instanceof StructureBlock) && !player.func_195070_dx()) {
            world.func_184138_a(pos, iblockstate, iblockstate, 3);
            return false;
        }
        world.func_217378_a(null, 2001, pos, Block.func_196246_j((BlockState)iblockstate));
        if (player.field_71075_bZ.field_75098_d) {
            flag1 = PlayerInteractionUtil.removeBlock(world, pos, (PlayerEntity)player, false);
            player.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
        } else {
            ItemStack itemstack1 = player.func_184614_ca();
            ItemStack itemstack2 = itemstack1.func_190926_b() ? ItemStack.field_190927_a : itemstack1.func_77946_l();
            boolean flag = iblockstate.canHarvestBlock((IBlockReader)world, pos, (PlayerEntity)player);
            itemstack1.func_179548_a(world, iblockstate, pos, (PlayerEntity)player);
            flag1 = PlayerInteractionUtil.removeBlock(world, pos, (PlayerEntity)player, flag);
            if (flag1 && flag) {
                iblockstate.func_177230_c().func_180657_a(world, (PlayerEntity)player, pos, iblockstate, tileentity, itemstack2);
            }
        }
        if (!player.func_184812_l_() && flag1 && exp > 0) {
            iblockstate.func_177230_c().func_180637_b(world, player.func_180425_c(), exp);
        }
        return flag1;
    }

    private static boolean removeBlock(World world, BlockPos pos, PlayerEntity player, boolean canHarvest) {
        BlockState iblockstate = world.func_180495_p(pos);
        boolean flag = iblockstate.func_177230_c().removedByPlayer(iblockstate, world, pos, player, canHarvest, null);
        if (flag) {
            iblockstate.func_177230_c().func_176206_d((IWorld)world, pos, iblockstate);
        }
        return flag;
    }

    @Nonnull
    public static BlockPlaceResult placeBlock(@Nonnull ItemStack searchStack, @Nonnull ServerPlayerEntity player, @Nonnull World worldIn, @Nonnull BlockPos newPosition, @Nonnull Direction facing, @Nonnull IEnergyStorage energy, float hitX, float hitY, float hitZ) {
        BlockItem itemBlock = (BlockItem)searchStack.func_77973_b();
        if (worldIn.func_217400_a(newPosition, (Entity)player)) {
            return BlockPlaceResult.FAIL_DENY;
        }
        long distance = Math.round(Math.sqrt(player.func_180425_c().func_177951_i((Vec3i)newPosition)));
        long cost = (long)OverloadedConfig.INSTANCE.multiToolConfig.placeBaseCost + (long)OverloadedConfig.INSTANCE.multiToolConfig.costPerMeterAway * distance;
        if (!(player.field_71075_bZ.field_75098_d || cost <= Integer.MAX_VALUE && cost >= 0L && (long)energy.getEnergyStored() >= cost)) {
            return BlockPlaceResult.FAIL_ENERGY;
        }
        IItemHandler inventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElse(null);
        int foundStackSlot = PlayerInteractionUtil.findItemStackSlot(searchStack, inventory);
        if (foundStackSlot == -1) {
            return BlockPlaceResult.FAIL_PREREQUISITE;
        }
        ItemStack foundStack = inventory.extractItem(foundStackSlot, 1, player.field_71075_bZ.field_75098_d);
        BlockItemUseContext context = new BlockItemUseContext(new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, new BlockRayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, newPosition, false)));
        BlockState blockstate = itemBlock.func_179223_d().func_196258_a(context);
        if (blockstate == null || !context.func_195991_k().func_180501_a(context.func_195995_a(), blockstate, 11)) {
            inventory.insertItem(foundStackSlot, foundStack, player.field_71075_bZ.field_75098_d);
            return BlockPlaceResult.FAIL_DENY;
        }
        BlockState blockstate1 = worldIn.func_180495_p(newPosition);
        Block block = blockstate1.func_177230_c();
        if (block == blockstate.func_177230_c()) {
            BlockItem.func_179224_a((World)worldIn, (PlayerEntity)player, (BlockPos)newPosition, (ItemStack)foundStack);
            block.func_180633_a(worldIn, newPosition, blockstate1, (LivingEntity)player, foundStack);
            CriteriaTriggers.field_193137_x.func_193173_a(player, newPosition, foundStack);
        }
        SoundType soundtype = worldIn.func_180495_p(newPosition).func_177230_c().getSoundType(worldIn.func_180495_p(newPosition), (IWorldReader)worldIn, newPosition, (Entity)player);
        worldIn.func_184133_a(null, newPosition, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        if (!player.field_71075_bZ.field_75098_d) {
            energy.extractEnergy((int)cost, false);
        }
        return BlockPlaceResult.SUCCESS;
    }

    private static int findItemStackSlot(@Nonnull ItemStack item, @Nonnull IItemHandler inventory) {
        int size = inventory.getSlots();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !stack.func_77969_a(item)) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public static BlockRayTraceResult getBlockPlayerLookingAtClient(PlayerEntity player, float partialTicks) {
        BlockRayTraceResult result = player.func_130014_f_().func_217299_a(new RayTraceContext(player.func_174824_e(partialTicks), player.func_70676_i(partialTicks).func_186678_a((double)OverloadedConfig.INSTANCE.multiToolConfig.reach).func_178787_e(player.func_174824_e(partialTicks)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
        return result;
    }
}

