/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.tile.functional;

import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.tile.ModTiles;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileMatterPurifier
extends TileEntity
implements ITickableTileEntity,
IItemHandler {
    private final FluidTank fluidStorage = new FluidTank(Integer.MAX_VALUE);
    private EnergyStorage energyStorage = new EnergyStorage(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private ItemStack stack = ItemStack.field_190927_a;

    public TileMatterPurifier() {
        super(ModTiles.matterPurifier);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.stack.func_190926_b()) {
            return;
        }
        float hardness = ((BlockItem)this.stack.func_77973_b()).func_179223_d().func_176195_g(null, null, null);
        if (hardness <= 0.0f) {
            return;
        }
        float ecFloat = (float)OverloadedConfig.INSTANCE.purifierConfig.energyPerOperation + (float)OverloadedConfig.INSTANCE.purifierConfig.energyPerHardness * hardness;
        int energyCost = Math.round(ecFloat);
        if (this.energyStorage.extractEnergy(energyCost, true) != energyCost) {
            return;
        }
        int createdFluid = Math.round(hardness);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.fluidStorage.readFromNBT((CompoundNBT)compound.func_74781_a("Fluid"));
        this.energyStorage = new EnergyStorage(compound.func_74762_e("Energy"), Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT fluid = new CompoundNBT();
        this.fluidStorage.writeToNBT(fluid);
        compound.func_218657_a("Fluid", (INBT)fluid);
        compound.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        return super.func_189515_b(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.fluidStorage).cast();
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.energyStorage).cast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(capability, facing);
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.stack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.stack.func_190926_b()) {
            if (!simulate) {
                this.stack = stack;
            }
            return ItemStack.field_190927_a;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack, (ItemStack)stack)) {
            int maxSize = this.stack.func_77976_d();
            int toTake = Math.min(maxSize - this.stack.func_190916_E(), stack.func_190916_E());
            if (!simulate) {
                this.stack.func_190920_e(this.stack.func_190916_E() + toTake);
            }
            ItemStack toReturn = stack.func_77946_l();
            toReturn.func_190920_e(stack.func_190916_E() - toTake);
            return toReturn;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.stack.func_77976_d();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }
}

