/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.tile.functional;

import com.cjm721.overloaded.storage.energy.ForgeEnergyZero;
import com.cjm721.overloaded.storage.energy.IHyperHandlerEnergy;
import com.cjm721.overloaded.storage.stacks.intint.LongEnergyStack;
import com.cjm721.overloaded.tile.ModTiles;
import com.cjm721.overloaded.tile.functional.AbstractTileEntityFaceable;
import com.cjm721.overloaded.util.CapabilityHyperEnergy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEnergyExtractor
extends AbstractTileEntityFaceable
implements ITickableTileEntity {
    public TileEnergyExtractor() {
        super(ModTiles.energyExtractor);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        BlockPos me = this.func_174877_v();
        TileEntity frontTE = this.func_145831_w().func_175625_s(me.func_177971_a(this.getFacing().func_176730_m()));
        if (frontTE == null) {
            return;
        }
        LazyOptional optionalStorage = frontTE.getCapability(CapabilityHyperEnergy.HYPER_ENERGY_HANDLER, this.getFacing().func_176734_d());
        if (!optionalStorage.isPresent()) {
            return;
        }
        IHyperHandlerEnergy storage = (IHyperHandlerEnergy)optionalStorage.orElse(null);
        for (Direction facing : Direction.values()) {
            TileEntity te;
            if (facing == this.getFacing() || (te = this.field_145850_b.func_175625_s(me.func_177971_a(facing.func_176730_m()))) == null) continue;
            LazyOptional optionalReceiver = te.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d());
            LongEnergyStack energy = storage.take(new LongEnergyStack(Long.MAX_VALUE), false);
            if (energy.getAmount() == 0L) {
                return;
            }
            optionalReceiver.ifPresent(receiver -> {
                if (!receiver.canReceive()) {
                    return;
                }
                int acceptedAmount = receiver.receiveEnergy((int)Math.min(energy.getAmount(), Integer.MAX_VALUE), true);
                if (acceptedAmount != 0) {
                    LongEnergyStack actualTaken = storage.take(new LongEnergyStack(acceptedAmount), true);
                    receiver.receiveEnergy((int)Math.min(actualTaken.getAmount(), Integer.MAX_VALUE), false);
                }
            });
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(ForgeEnergyZero::new).cast();
        }
        return super.getCapability(cap, side);
    }
}

