/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.itemwrapper;

import com.cjm721.overloaded.storage.energy.IHyperHandlerEnergy;
import com.cjm721.overloaded.storage.energy.LongEnergyStorage;
import com.cjm721.overloaded.storage.stacks.intint.LongEnergyStack;
import com.cjm721.overloaded.util.CapabilityHyperEnergy;
import com.cjm721.overloaded.util.IDataUpdate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class LongEnergyWrapper
implements ICapabilityProvider,
IEnergyStorage,
IHyperHandlerEnergy,
IDataUpdate {
    private final ItemStack stack;

    public LongEnergyWrapper(ItemStack stack) {
        this.stack = stack;
        CompoundNBT tagCompound = this.stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (!tagCompound.func_74764_b("EnergyStorage")) {
            LongEnergyStorage storage = new LongEnergyStorage(this);
            CompoundNBT storageTag = storage.serializeNBT();
            tagCompound.func_218657_a("EnergyStorage", (INBT)storageTag);
            this.stack.func_77982_d(tagCompound);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY || capability == CapabilityHyperEnergy.HYPER_ENERGY_HANDLER) {
            return LazyOptional.of(() -> this).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    @Nonnull
    public LongEnergyStack status() {
        return this.getStorage().status();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public LongEnergyStack take(@Nonnull LongEnergyStack stack, boolean doAction) {
        LongEnergyStorage storage = this.getStorage();
        try {
            LongEnergyStack longEnergyStack = storage.take(stack, doAction);
            return longEnergyStack;
        }
        finally {
            this.setStorage(storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public LongEnergyStack give(@Nonnull LongEnergyStack stack, boolean doAction) {
        LongEnergyStorage storage = this.getStorage();
        try {
            LongEnergyStack longEnergyStack = storage.give(stack, doAction);
            return longEnergyStack;
        }
        finally {
            this.setStorage(storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveEnergy(int maxReceive, boolean simulate) {
        LongEnergyStorage storage = this.getStorage();
        try {
            int n = storage.receiveEnergy(maxReceive, simulate);
            return n;
        }
        finally {
            this.setStorage(storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int extractEnergy(int maxExtract, boolean simulate) {
        LongEnergyStorage storage = this.getStorage();
        try {
            int n = storage.extractEnergy(maxExtract, simulate);
            return n;
        }
        finally {
            this.setStorage(storage);
        }
    }

    public int getEnergyStored() {
        return this.getStorage().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getStorage().getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.getStorage().canExtract();
    }

    public boolean canReceive() {
        return this.getStorage().canReceive();
    }

    @Nonnull
    private LongEnergyStorage getStorage() {
        CompoundNBT compound = this.stack.func_77978_p().func_74775_l("EnergyStorage");
        LongEnergyStorage storage = new LongEnergyStorage(this);
        storage.deserializeNBT(compound);
        return storage;
    }

    private void setStorage(@Nonnull LongEnergyStorage storage) {
        CompoundNBT compound = storage.serializeNBT();
        this.stack.func_77978_p().func_218657_a("EnergyStorage", (INBT)compound);
    }

    @Override
    public void dataUpdated() {
    }
}

