/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.item;

import com.cjm721.overloaded.storage.INBTConvertible;
import com.cjm721.overloaded.storage.item.IHyperHandlerItem;
import com.cjm721.overloaded.storage.stacks.bigint.BigIntItemStack;
import com.cjm721.overloaded.storage.stacks.intint.LongItemStack;
import com.cjm721.overloaded.util.IDataUpdate;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.items.ItemHandlerHelper;

public class BigIntItemStorage
implements IHyperHandlerItem,
INBTConvertible {
    @Nonnull
    private final IDataUpdate dataUpdate;
    @Nonnull
    private BigIntItemStack storedItem;

    public BigIntItemStorage(@Nonnull IDataUpdate dataUpdate) {
        this.dataUpdate = dataUpdate;
        this.storedItem = new BigIntItemStack(ItemStack.field_190927_a, BigInteger.ZERO);
    }

    @Override
    public void read(CompoundNBT compound) {
        ItemStack itemStack = compound.func_74764_b("Stack") ? ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("Stack"))) : ItemStack.field_190927_a;
        BigInteger amount = compound.func_74764_b("Count") ? new BigInteger(compound.func_74770_j("Count")) : BigInteger.ZERO;
        this.storedItem = new BigIntItemStack(itemStack, amount);
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        if (this.storedItem.itemStack != ItemStack.field_190927_a) {
            CompoundNBT tag = new CompoundNBT();
            this.storedItem.itemStack.func_77955_b(tag);
            compound.func_218657_a("Stack", (INBT)tag);
            compound.func_74773_a("Count", this.storedItem.amount.toByteArray());
        }
        return compound;
    }

    @Override
    @Nonnull
    public LongItemStack status() {
        return new LongItemStack(this.storedItem.itemStack, this.storedItem.amount.min(BigInteger.valueOf(Long.MAX_VALUE)).longValueExact());
    }

    @Override
    @Nonnull
    public LongItemStack take(@Nonnull LongItemStack stack, boolean doAction) {
        if (this.storedItem.itemStack.func_190926_b()) {
            return LongItemStack.EMPTY_STACK;
        }
        long result = this.storedItem.amount.min(BigInteger.valueOf(stack.getAmount())).longValueExact();
        LongItemStack toReturn = new LongItemStack(this.storedItem.itemStack, result);
        if (doAction) {
            this.storedItem.amount = this.storedItem.amount.subtract(BigInteger.valueOf(result));
            if (this.storedItem.amount.equals(BigInteger.ZERO)) {
                this.storedItem.itemStack = ItemStack.field_190927_a;
            }
            this.dataUpdate.dataUpdated();
        }
        return toReturn;
    }

    @Override
    @Nonnull
    public LongItemStack give(@Nonnull LongItemStack stack, boolean doAction) {
        if (this.storedItem.itemStack.func_190926_b()) {
            if (doAction) {
                this.storedItem = new BigIntItemStack(stack.getItemStack(), BigInteger.valueOf(stack.getAmount()));
                this.dataUpdate.dataUpdated();
            }
            return LongItemStack.EMPTY_STACK;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.storedItem.itemStack, (ItemStack)stack.getItemStack())) {
            if (doAction) {
                this.storedItem.amount = this.storedItem.amount.add(BigInteger.valueOf(stack.getAmount()));
                this.dataUpdate.dataUpdated();
            }
            return LongItemStack.EMPTY_STACK;
        }
        return stack;
    }
}

