/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.fluid;

import com.cjm721.overloaded.storage.INBTConvertible;
import com.cjm721.overloaded.storage.fluid.IHyperHandlerFluid;
import com.cjm721.overloaded.storage.stacks.bigint.BigIntFluidStack;
import com.cjm721.overloaded.storage.stacks.intint.LongFluidStack;
import com.cjm721.overloaded.util.FluidUtil;
import com.cjm721.overloaded.util.IDataUpdate;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;

public class BigIntFluidStorage
implements IHyperHandlerFluid,
INBTConvertible {
    @Nonnull
    private final IDataUpdate dataUpdate;
    @Nonnull
    private BigIntFluidStack storedFluid;

    public BigIntFluidStorage(@Nonnull IDataUpdate dataUpdate) {
        this.dataUpdate = dataUpdate;
        this.storedFluid = new BigIntFluidStack(null, BigInteger.ZERO);
    }

    @Override
    public void read(CompoundNBT compound) {
        FluidStack fluidStack = compound.func_74764_b("Fluid") ? FluidStack.loadFluidStackFromNBT((CompoundNBT)((CompoundNBT)compound.func_74781_a("Fluid"))) : null;
        BigInteger amount = compound.func_74764_b("Count") ? new BigInteger(compound.func_74770_j("Count")) : BigInteger.ZERO;
        this.storedFluid = new BigIntFluidStack(fluidStack, amount);
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        if (this.storedFluid.fluidStack != null) {
            CompoundNBT tag = new CompoundNBT();
            this.storedFluid.fluidStack.writeToNBT(tag);
            compound.func_218657_a("Fluid", (INBT)tag);
            compound.func_74773_a("Count", this.storedFluid.amount.toByteArray());
        }
        return compound;
    }

    @Override
    @Nonnull
    public LongFluidStack status() {
        return new LongFluidStack(this.storedFluid.fluidStack, this.storedFluid.amount.min(BigInteger.valueOf(Long.MAX_VALUE)).longValueExact());
    }

    @Override
    @Nonnull
    public LongFluidStack take(@Nonnull LongFluidStack stack, boolean doAction) {
        if (this.storedFluid.fluidStack == null) {
            return LongFluidStack.EMPTY_STACK;
        }
        if (stack.fluidStack != null && !FluidUtil.fluidsAreEqual(this.storedFluid.fluidStack, stack.fluidStack)) {
            return LongFluidStack.EMPTY_STACK;
        }
        BigInteger takingAmount = BigInteger.valueOf(stack.amount);
        LongFluidStack toReturn = new LongFluidStack(this.storedFluid.fluidStack, this.storedFluid.amount.min(takingAmount).longValueExact());
        if (doAction) {
            this.storedFluid.amount = this.storedFluid.amount.subtract(takingAmount);
            if (this.storedFluid.amount.equals(BigInteger.ZERO)) {
                this.storedFluid.fluidStack = null;
            }
            this.dataUpdate.dataUpdated();
        }
        return toReturn;
    }

    @Override
    @Nonnull
    public LongFluidStack give(@Nonnull LongFluidStack fluidStack, boolean doAction) {
        if (this.storedFluid.fluidStack == null) {
            if (doAction) {
                this.storedFluid.fluidStack = fluidStack.fluidStack;
                this.dataUpdate.dataUpdated();
            }
            return LongFluidStack.EMPTY_STACK;
        }
        if (FluidUtil.fluidsAreEqual(this.storedFluid.fluidStack, fluidStack.fluidStack)) {
            if (doAction) {
                this.storedFluid.amount = this.storedFluid.amount.add(BigInteger.valueOf(fluidStack.amount));
                this.dataUpdate.dataUpdated();
            }
            return new LongFluidStack(this.storedFluid.fluidStack, 0L);
        }
        return fluidStack;
    }
}

