/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.network.handler;

import com.cjm721.overloaded.network.handler.IPlayerMessageMethod;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayerMessageHandler<T>
implements BiConsumer<T, Supplier<NetworkEvent.Context>> {
    private final IPlayerMessageMethod<T> method;

    public PlayerMessageHandler(@Nonnull IPlayerMessageMethod<T> method) {
        this.method = method;
    }

    @Override
    public void accept(T message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player == null) {
            return;
        }
        ctx.get().enqueueWork(() -> this.method.handleMessage(player, message));
        ctx.get().setPacketHandled(true);
    }
}

