/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.network.handler;

import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.config.syncer.ConfigSyncMerger;
import com.cjm721.overloaded.network.packets.ConfigSyncMessage;
import com.google.gson.Gson;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class ConfigSyncHandler
implements BiConsumer<ConfigSyncMessage, Supplier<NetworkEvent.Context>> {
    public static ConfigSyncHandler INSTANCE = new ConfigSyncHandler();
    private final ConfigSyncMerger configSyncMerger = new ConfigSyncMerger();
    private OverloadedConfig serverConfigOptions;

    private ConfigSyncHandler() {
    }

    public void updateConfig() {
        Gson gson = new Gson();
        if (this.serverConfigOptions == null) {
            return;
        }
        try {
            this.configSyncMerger.updateConfigFromServer(OverloadedConfig.INSTANCE, this.serverConfigOptions);
        }
        catch (IllegalAccessException e) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Unable to sync settings with server. Some GUIs / items may not behave as expected."));
            e.printStackTrace();
        }
    }

    public void clearServerConfigOptions() {
        this.serverConfigOptions = null;
    }

    @Override
    public void accept(ConfigSyncMessage message, Supplier<NetworkEvent.Context> ctx) {
        OverloadedConfig serverConfigEntires;
        this.serverConfigOptions = serverConfigEntires = (OverloadedConfig)new Gson().fromJson(message.config, OverloadedConfig.class);
        this.updateConfig();
    }
}

