/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional.armor;

import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.client.render.entity.RenderMultiHelmet;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.functional.armor.AbstractMultiArmor;
import com.cjm721.overloaded.network.packets.MultiArmorSettingsMessage;
import com.cjm721.overloaded.storage.GenericDataStorage;
import com.cjm721.overloaded.storage.IGenericDataStorage;
import com.cjm721.overloaded.storage.itemwrapper.GenericDataCapabilityProviderWrapper;
import com.google.common.primitives.Floats;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemMultiHelmet
extends AbstractMultiArmor {
    private RenderMultiHelmet armorModel;

    public ItemMultiHelmet() {
        super(EquipmentSlotType.HEAD);
        this.setRegistryName("multi_helmet");
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        if (this.armorModel == null) {
            this.armorModel = new RenderMultiHelmet();
        }
        return (A)((Object)this.armorModel);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), null);
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/item/multi_helmet.png"), OverloadedConfig.INSTANCE.textureResolutions.multiArmorResolution);
    }

    public void updateSettings(ServerPlayerEntity ServerPlayerEntity2, MultiArmorSettingsMessage message) {
        for (ItemStack itemStack : ServerPlayerEntity2.func_184193_aE()) {
            if (itemStack.func_77973_b() != this) continue;
            this.updateSettings(itemStack, message);
        }
    }

    @Override
    public Collection<ICapabilityProvider> collectCapabilities(@Nonnull Collection<ICapabilityProvider> collection, ItemStack stack, @Nullable CompoundNBT nbt) {
        collection.add(new GenericDataCapabilityProviderWrapper(stack));
        return super.collectCapabilities(collection, stack, nbt);
    }

    private void updateSettings(ItemStack itemStack, MultiArmorSettingsMessage message) {
        IGenericDataStorage settings = (IGenericDataStorage)itemStack.getCapability(GenericDataStorage.GENERIC_DATA_STORAGE).orElse(null);
        settings.suggestUpdate();
        Map<String, Float> floats = settings.getFloatMap();
        floats.put("flight_speed", Float.valueOf(Floats.constrainToRange((float)message.flightSpeed, (float)0.0f, (float)((float)OverloadedConfig.INSTANCE.multiArmorConfig.maxFlightSpeed))));
        floats.put("ground_speed", Float.valueOf(Floats.constrainToRange((float)message.groundSpeed, (float)0.0f, (float)((float)OverloadedConfig.INSTANCE.multiArmorConfig.maxGroundSpeed))));
        Map<String, Boolean> booleans = settings.getBooleanMap();
        booleans.put("noclip_flight_lock", message.noclipFlightLock);
        booleans.put("flight", message.flight);
        booleans.put("feed", message.feed);
        booleans.put("heal", message.heal);
        booleans.put("remove_harmful", message.removeHarmful);
        booleans.put("give_air", message.air);
        booleans.put("extinguish", message.extinguish);
        settings.suggestSave();
    }
}

