/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional;

import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.functional.PowerModItem;
import com.cjm721.overloaded.network.packets.RailGunFireMessage;
import com.cjm721.overloaded.network.packets.RailGunSettingsMessage;
import com.cjm721.overloaded.storage.GenericDataStorage;
import com.cjm721.overloaded.storage.IGenericDataStorage;
import com.cjm721.overloaded.storage.itemwrapper.GenericDataCapabilityProviderWrapper;
import com.google.common.primitives.Ints;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ItemRailGun
extends PowerModItem {
    @Nonnull
    private static final String RAILGUN_POWER_KEY = "railgun.power";

    public ItemRailGun() {
        this.setRegistryName("railgun");
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        stack.getCapability(GenericDataStorage.GENERIC_DATA_STORAGE).ifPresent(cap -> {
            cap.suggestUpdate();
            int energyRequirement = cap.getIntegerMap().getOrDefault(RAILGUN_POWER_KEY, OverloadedConfig.INSTANCE.railGun.minEnergy);
            tooltip.add((ITextComponent)new StringTextComponent(String.format("Power Usage: %s", NumberFormat.getInstance().format(energyRequirement))));
        });
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "railgun"), null);
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/item/railgun.png"), OverloadedConfig.INSTANCE.textureResolutions.itemResolution);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        if (worldIn.field_72995_K) {
            // empty if block
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onMouseEvent(@Nonnull InputEvent.MouseInputEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
    }

    public void handleFireMessage(@Nonnull ServerPlayerEntity player, @Nonnull RailGunFireMessage message) {
        ItemStack itemStack = player.func_184586_b(message.hand);
        if (itemStack.func_77973_b() != this) {
            return;
        }
        IEnergyStorage energy = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        IGenericDataStorage settingCapability = (IGenericDataStorage)itemStack.getCapability(GenericDataStorage.GENERIC_DATA_STORAGE).orElse(null);
        settingCapability.suggestUpdate();
        int energyRequired = settingCapability.getIntegerMap().getOrDefault(RAILGUN_POWER_KEY, OverloadedConfig.INSTANCE.railGun.minEnergy);
        if (energy.getEnergyStored() < energyRequired) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Not enough power to fire."), true);
            return;
        }
        int energyExtracted = energy.extractEnergy(energyRequired, false);
        Entity entity = player.field_70170_p.func_73045_a(message.id);
        if (entity == null || !entity.func_70089_S()) {
            return;
        }
        if (player.func_70032_d(entity) > (float)OverloadedConfig.INSTANCE.rayGun.maxRange) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Target out of range."), true);
        } else if (entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), (float)(OverloadedConfig.INSTANCE.railGun.damagePerRF * (double)energyExtracted))) {
            Vec3d knockback = message.moveVector.func_186678_a((double)energyExtracted * OverloadedConfig.INSTANCE.railGun.knockbackPerRF);
            entity.func_70024_g(knockback.field_72450_a, knockback.field_72448_b, knockback.field_72449_c);
        }
    }

    @Override
    public Collection<ICapabilityProvider> collectCapabilities(@Nonnull Collection<ICapabilityProvider> collection, ItemStack stack, @Nullable CompoundNBT nbt) {
        collection.add(new GenericDataCapabilityProviderWrapper(stack));
        return super.collectCapabilities(collection, stack, nbt);
    }

    public void handleSettingsMessage(@Nonnull ServerPlayerEntity player, @Nonnull RailGunSettingsMessage message) {
        ItemStack itemStack = player.func_184586_b(Hand.MAIN_HAND);
        if (itemStack.func_77973_b() != this) {
            return;
        }
        IGenericDataStorage cap = (IGenericDataStorage)itemStack.getCapability(GenericDataStorage.GENERIC_DATA_STORAGE).orElse(null);
        Map<String, Integer> integerMap = cap.getIntegerMap();
        int power = integerMap.getOrDefault(RAILGUN_POWER_KEY, 0) + message.powerDelta;
        power = Ints.constrainToRange((int)power, (int)OverloadedConfig.INSTANCE.railGun.minEnergy, (int)OverloadedConfig.INSTANCE.railGun.maxEnergy);
        integerMap.put(RAILGUN_POWER_KEY, power);
        cap.suggestSave();
        player.func_146105_b((ITextComponent)new StringTextComponent("Power usage set to: " + NumberFormat.getInstance().format(power)), true);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="forge", bus=Mod.EventBusSubscriber.Bus.FORGE)
    private static class ClientSideEvents {
        private ClientSideEvents() {
        }
    }
}

