/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.ModItems;
import com.cjm721.overloaded.item.functional.PowerModItem;
import com.cjm721.overloaded.network.packets.LeftClickBlockMessage;
import com.cjm721.overloaded.network.packets.RightClickBlockMessage;
import com.cjm721.overloaded.util.BlockBreakResult;
import com.cjm721.overloaded.util.BlockPlaceResult;
import com.cjm721.overloaded.util.PlayerInteractionUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.ServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemMultiTool
extends PowerModItem {
    public ItemMultiTool() {
        super(new Item.Properties().addToolType(ToolType.AXE, Integer.MAX_VALUE).addToolType(ToolType.PICKAXE, Integer.MAX_VALUE).addToolType(ToolType.SHOVEL, Integer.MAX_VALUE));
        this.setRegistryName("multi_tool");
    }

    private static double getDistance(@Nonnull LivingEntity entityLiving, @Nonnull BlockPos pos) {
        return Math.sqrt(entityLiving.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    private static float getBreakCost(float hardness, int efficiency, int unbreaking, double distance) {
        return (float)((double)(hardness * (float)OverloadedConfig.INSTANCE.multiToolConfig.breakCostMultiplier / (float)(efficiency + 1) + (float)(OverloadedConfig.INSTANCE.multiToolConfig.breakBaseCost / (unbreaking + 1))) + distance);
    }

    @Nonnull
    private static BlockBreakResult breakAndUseEnergy(@Nonnull World worldIn, @Nonnull BlockPos blockPos, @Nonnull IEnergyStorage energy, @Nonnull ServerPlayerEntity player, int efficiency, int unbreaking) {
        BlockState state = worldIn.func_180495_p(blockPos);
        if (!player.field_71075_bZ.field_75098_d) {
            float hardness = state.func_185887_b((IBlockReader)worldIn, blockPos);
            if (hardness < 0.0f) {
                return BlockBreakResult.FAIL_UNBREAKABLE;
            }
            float floatBreakCost = ItemMultiTool.getBreakCost(hardness, efficiency, unbreaking, ItemMultiTool.getDistance((LivingEntity)player, blockPos));
            if (Float.isInfinite(floatBreakCost) || Float.isNaN(floatBreakCost)) {
                return BlockBreakResult.FAIL_ENERGY;
            }
            int breakCost = Math.round(floatBreakCost);
            if (breakCost < 0 || energy.getEnergyStored() < breakCost) {
                return BlockBreakResult.FAIL_ENERGY;
            }
        }
        if (player.func_70092_e((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()) > (double)(OverloadedConfig.INSTANCE.multiToolConfig.reach * OverloadedConfig.INSTANCE.multiToolConfig.reach)) {
            return BlockBreakResult.FAIL_RANGE;
        }
        if (!state.func_177230_c().canEntityDestroy(state, (IBlockReader)worldIn, blockPos, (Entity)player)) {
            return BlockBreakResult.FAIL_REMOVE;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(worldIn, blockPos, state, (PlayerEntity)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return BlockBreakResult.FAIL_REMOVE;
        }
        boolean result = PlayerInteractionUtil.tryHarvestBlock(player, worldIn, blockPos);
        return result ? BlockBreakResult.SUCCESS : BlockBreakResult.FAIL_REMOVE;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void leftClickOnBlockClient(BlockPos pos) {
        Overloaded.proxy.networkWrapper.sendToServer((Object)new LeftClickBlockMessage(pos));
    }

    public static void leftClickOnBlockServer(@Nonnull ServerPlayerEntity player, LeftClickBlockMessage message) {
        BlockPos pos = message.getPos();
        ServerWorld world = player.func_71121_q();
        ItemStack itemStack = player.func_184586_b(Hand.MAIN_HAND);
        if (itemStack.func_77973_b() != ModItems.multiTool || world.func_175623_d(pos)) {
            return;
        }
        player.func_184598_c(Hand.MAIN_HAND);
        if (player.func_70093_af()) {
            CompoundNBT tag = itemStack.func_77978_p();
            if (tag == null) {
                tag = new CompoundNBT();
            }
            BlockState state = world.func_180495_p(pos);
            Item item = Item.func_150898_a((Block)state.func_177230_c());
            ItemStack stackToPlace = new ItemStack(() -> item, 1);
            CompoundNBT blockTag = new CompoundNBT();
            stackToPlace.func_77955_b(blockTag);
            tag.func_218657_a("Item", (INBT)blockTag);
            itemStack.func_77982_d(tag);
            ITextComponent component = stackToPlace.func_151000_E();
            player.func_146105_b(new StringTextComponent("Bound tool to ").func_150257_a(component), true);
        } else {
            IEnergyStorage energy = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY).orElse(null);
            int efficiency = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)itemStack);
            int unbreaking = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)itemStack);
            switch (ItemMultiTool.breakAndUseEnergy((World)world, pos, energy, player, efficiency, unbreaking)) {
                case FAIL_REMOVE: {
                    player.func_146105_b((ITextComponent)new StringTextComponent("Unable to break block, reason unknown"), true);
                    break;
                }
                case FAIL_ENERGY: {
                    player.func_146105_b((ITextComponent)new StringTextComponent("Unable to break block, not enough energy"), true);
                    break;
                }
                case FAIL_UNBREAKABLE: {
                    player.func_146105_b((ITextComponent)new StringTextComponent("Block is unbreakable"), true);
                    break;
                }
                case FAIL_RANGE: {
                    player.func_146105_b((ITextComponent)new StringTextComponent("Block is out of range."), true);
                    break;
                }
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != null && enchantment.field_77351_y == EnchantmentType.DIGGER;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 15;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return this.getItemStackLimit(stack) == 1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "multi_tool"), null);
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/item/multi_tool.png"), OverloadedConfig.INSTANCE.textureResolutions.itemResolution);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        LazyOptional storage = stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (storage.isPresent()) {
            int efficiency = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
            int unbreaking = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
            float breakCost = ItemMultiTool.getBreakCost(worldIn.func_180495_p(pos).func_185887_b((IBlockReader)worldIn, pos), efficiency, unbreaking, entityLiving == null ? 10.0 : ItemMultiTool.getDistance(entityLiving, pos));
            ((IEnergyStorage)storage.orElse(null)).extractEnergy((int)Math.min(2.1474836E9f, breakCost), false);
        }
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public boolean func_150897_b(BlockState blockIn) {
        return false;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return 0.0f;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        BlockRayTraceResult result;
        if (worldIn.field_72995_K && (result = PlayerInteractionUtil.getBlockPlayerLookingAtClient(player, Minecraft.func_71410_x().func_184121_ak())) != null) {
            Overloaded.proxy.networkWrapper.sendToServer((Object)new RightClickBlockMessage(result.func_216350_a(), result.func_216354_b(), (float)result.func_216347_e().field_72450_a - (float)result.func_216350_a().func_177958_n(), (float)result.func_216347_e().field_72448_b - (float)result.func_216350_a().func_177956_o(), (float)result.func_216347_e().field_72449_c - (float)result.func_216350_a().func_177952_p()));
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void rightClickWithItem(@Nonnull ServerPlayerEntity player, RightClickBlockMessage message) {
        BlockPos pos = message.getPos();
        Direction sideHit = message.getHitSide();
        float hitX = message.getHitX();
        float hitY = message.getHitY();
        float hitZ = message.getHitZ();
        ServerWorld worldIn = player.func_71121_q();
        ItemStack multiTool = player.func_184614_ca();
        if (multiTool.func_77973_b() != this) {
            return;
        }
        ItemStack blockStack = this.getSelectedBlockItemStack(multiTool);
        if (blockStack.func_190926_b()) {
            player.func_146105_b((ITextComponent)new StringTextComponent("No block type selected to place."), true);
            return;
        }
        if (!(blockStack.func_77973_b() instanceof BlockItem)) {
            player.func_146105_b((ITextComponent)new StringTextComponent("No valid block type selected to place."), true);
            return;
        }
        IEnergyStorage energy = (IEnergyStorage)multiTool.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        Vec3i sideVector = sideHit.func_176730_m();
        BlockPos.MutableBlockPos newPosition = new BlockPos.MutableBlockPos(pos.func_177971_a(sideVector));
        switch (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ)) {
            case FAIL_PREREQUISITE: {
                player.func_146105_b((ITextComponent)new StringTextComponent("Do not have the required items"), true);
                return;
            }
            case FAIL_DENY: {
                player.func_146105_b((ITextComponent)new StringTextComponent("Unable to place blocks"), true);
                return;
            }
            case FAIL_RANGE: {
                player.func_146105_b((ITextComponent)new StringTextComponent("To far away"), true);
                return;
            }
            case FAIL_ENERGY: {
                player.func_146105_b((ITextComponent)new StringTextComponent("Not enough energy"), true);
                return;
            }
        }
        if (player.func_70093_af()) {
            BlockPos playerPos = player.func_180425_c();
            block6 : switch (sideHit) {
                case UP: {
                    while (newPosition.func_177956_o() < playerPos.func_177956_o()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ) == BlockPlaceResult.SUCCESS) continue;
                        break block6;
                    }
                    break;
                }
                case DOWN: {
                    while (newPosition.func_177956_o() > playerPos.func_177956_o()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ) == BlockPlaceResult.SUCCESS) continue;
                        break block6;
                    }
                    break;
                }
                case NORTH: {
                    while (newPosition.func_177952_p() > playerPos.func_177952_p()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ) == BlockPlaceResult.SUCCESS) continue;
                        break block6;
                    }
                    break;
                }
                case SOUTH: {
                    while (newPosition.func_177952_p() < playerPos.func_177952_p()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ) == BlockPlaceResult.SUCCESS) continue;
                        break block6;
                    }
                    break;
                }
                case EAST: {
                    while (newPosition.func_177958_n() < playerPos.func_177958_n()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ) == BlockPlaceResult.SUCCESS) continue;
                        break block6;
                    }
                    break;
                }
                case WEST: {
                    while (newPosition.func_177958_n() > playerPos.func_177958_n()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, (World)worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ) == BlockPlaceResult.SUCCESS) continue;
                        break block6;
                    }
                    break;
                }
            }
        }
    }

    public boolean func_195938_a(BlockState p_195938_1_, World p_195938_2_, BlockPos p_195938_3_, PlayerEntity p_195938_4_) {
        return !p_195938_4_.func_70093_af();
    }

    @Nonnull
    public ItemStack getSelectedBlockItemStack(ItemStack multiTool) {
        CompoundNBT tagCompound = multiTool.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("Item")) {
            return ItemStack.field_190927_a;
        }
        CompoundNBT itemTag = tagCompound.func_74775_l("Item");
        return ItemStack.func_199557_a((CompoundNBT)itemTag);
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return true;
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        return super.func_200295_i(stack).func_211708_a(TextFormatting.GOLD);
    }

    @Mod.EventBusSubscriber(modid="overloaded", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class CommonSideEvents {
        @SubscribeEvent(priority=EventPriority.LOW)
        public static void teleportDrops(@Nonnull BlockEvent.HarvestDropsEvent event) {
            PlayerEntity player = event.getHarvester();
            if (player == null || event.getHarvester().func_184614_ca().func_77973_b() != ModItems.multiTool || event.getDrops() instanceof ImmutableList) {
                return;
            }
            IWorld world = event.getWorld();
            float chance = event.getDropChance();
            for (ItemStack stack : event.getDrops()) {
                if (!(world.func_201674_k().nextFloat() <= chance)) continue;
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
            }
            event.getDrops().clear();
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="overloaded", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientSideEvents {
        @SubscribeEvent
        public static void leftClickBlock(@Nonnull PlayerInteractEvent.LeftClickBlock event) {
            if (!event.getEntityPlayer().func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                return;
            }
            ItemStack stack = event.getItemStack();
            if (stack.func_77973_b().equals(ModItems.multiTool)) {
                ItemMultiTool.leftClickOnBlockClient(event.getPos());
            }
        }

        @SubscribeEvent
        public static void leftClickEmpty(@Nonnull PlayerInteractEvent.LeftClickEmpty event) {
            PlayerEntity entityLiving;
            BlockRayTraceResult result;
            if (event.getSide() == LogicalSide.SERVER || event.getEntityPlayer() != Minecraft.func_71410_x().field_71439_g) {
                return;
            }
            ItemStack stack = event.getItemStack();
            if (stack.func_77973_b().equals(ModItems.multiTool) && (result = PlayerInteractionUtil.getBlockPlayerLookingAtClient(entityLiving = event.getEntityPlayer(), Minecraft.func_71410_x().func_184121_ak())).func_216346_c() != RayTraceResult.Type.MISS) {
                ItemMultiTool.leftClickOnBlockClient(result.func_216350_a());
            }
        }
    }
}

