/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional;

import com.cjm721.overloaded.item.ModItem;
import com.cjm721.overloaded.storage.energy.IHyperHandlerEnergy;
import com.cjm721.overloaded.storage.itemwrapper.LongEnergyWrapper;
import com.cjm721.overloaded.storage.stacks.intint.LongEnergyStack;
import com.cjm721.overloaded.util.CapabilityHyperEnergy;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemEnergyShield
extends ModItem {
    private final long constantUseCost = 100L;
    private final long initialUseCost = 10000L;

    public ItemEnergyShield() {
        super(new Item.Properties().func_200917_a(1).func_200918_c(500));
        this.setRegistryName("energy_shield");
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)ArmorItem.field_96605_cw);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "energy_shield"), null);
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        System.out.println("Blocking");
        return UseAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K) {
            System.out.println("On Item Use");
            IHyperHandlerEnergy handler = (IHyperHandlerEnergy)context.func_195996_i().getCapability(CapabilityHyperEnergy.HYPER_ENERGY_HANDLER).orElse(null);
            LongEnergyStack energy = handler.take(new LongEnergyStack(100L), true);
            if (energy.amount == 100L) {
                System.out.println("On Item Use Success");
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player.func_184585_cz()) {
            System.out.println("On Using Tick Blocking: " + count);
            return;
        }
        System.out.println("On Using Tick Not Blocking: " + count);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        IHyperHandlerEnergy handler = (IHyperHandlerEnergy)itemstack.getCapability(CapabilityHyperEnergy.HYPER_ENERGY_HANDLER).orElse(null);
        LongEnergyStack energy = handler.take(new LongEnergyStack(10000L), true);
        if (energy.amount == 10000L) {
            System.out.println("Right click Success");
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        System.out.println("Right click FAIL");
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new LongEnergyWrapper(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        stack.getCapability(CapabilityHyperEnergy.HYPER_ENERGY_HANDLER).ifPresent(handler -> tooltip.add((ITextComponent)new StringTextComponent("Energy Stored: " + ((LongEnergyStack)handler.status()).getAmount())));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        return stack.func_77978_p();
    }

    public boolean func_179215_a(CompoundNBT nbt) {
        return false;
    }
}

