/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.config;

import com.cjm721.overloaded.config.ConfigSectionHandler;
import com.cjm721.overloaded.config.DevelopmentConfig;
import com.cjm721.overloaded.config.MultiArmorConfig;
import com.cjm721.overloaded.config.MultiToolConfig;
import com.cjm721.overloaded.config.PurifierConfig;
import com.cjm721.overloaded.config.RailGunConfig;
import com.cjm721.overloaded.config.RayGunConfig;
import com.cjm721.overloaded.config.ResolutionConfig;
import com.cjm721.overloaded.config.SpecialConfig;
import com.cjm721.overloaded.config.syncer.SyncToClient;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="overloaded", bus=Mod.EventBusSubscriber.Bus.MOD)
public class OverloadedConfig {
    public static OverloadedConfig INSTANCE = new OverloadedConfig();
    @SyncToClient
    public MultiToolConfig multiToolConfig = new MultiToolConfig();
    @SyncToClient
    public MultiArmorConfig multiArmorConfig = new MultiArmorConfig();
    @SyncToClient
    public DevelopmentConfig developmentConfig = new DevelopmentConfig();
    public ResolutionConfig textureResolutions = new ResolutionConfig();
    @SyncToClient
    public PurifierConfig purifierConfig = new PurifierConfig();
    public SpecialConfig specialConfig = new SpecialConfig();
    @SyncToClient
    public RayGunConfig rayGun = new RayGunConfig();
    @SyncToClient
    public RailGunConfig railGun = new RailGunConfig();
    private final ImmutableList<ConfigSectionHandler> configsSections = ImmutableList.of((Object)this.multiToolConfig, (Object)this.multiArmorConfig, (Object)this.developmentConfig, (Object)this.textureResolutions, (Object)this.purifierConfig, (Object)this.specialConfig, (Object)this.rayGun, (Object)this.railGun);

    private OverloadedConfig() {
    }

    public ForgeConfigSpec load(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        ForgeConfigSpec configSpec = this.getConfig();
        configSpec.setConfig((CommentedConfig)configData);
        this.updateConfigs();
        return configSpec;
    }

    @SubscribeEvent
    public static void onLoading(ModConfig.Loading loading) {
        INSTANCE.updateConfigs();
    }

    @SubscribeEvent
    public static void onConfigRelaoding(ModConfig.ConfigReloading configReloading) {
        INSTANCE.updateConfigs();
    }

    private ForgeConfigSpec getConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.configsSections.stream().forEach(c -> c.appendToBuilder(builder));
        return builder.build();
    }

    private void updateConfigs() {
        this.configsSections.stream().forEach(ConfigSectionHandler::update);
    }
}

