/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.resource;

import com.cjm721.overloaded.client.resource.AbstractInjectableResoucePack;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlockResourcePack
extends AbstractInjectableResoucePack {
    public static final BlockResourcePack INSTANCE = new BlockResourcePack();
    private final Map<ResourceLocation, BufferedImage> images = Maps.newHashMap();
    private final Map<ResourceLocation, String> blockStates = Maps.newHashMap();
    private final Set<String> domains = Sets.newHashSet();

    private BlockResourcePack() {
    }

    public void addImage(@Nonnull ResourceLocation res, @Nonnull BufferedImage image) {
        this.images.put(res, image);
    }

    public void addBlockState(ResourceLocation res, String state) {
        this.blockStates.put(res, state);
    }

    public void addDomain(String domain) {
        this.domains.add(domain);
    }

    private InputStream getImageInputStream(@Nonnull ResourceLocation location) throws IOException {
        BufferedImage image = this.images.get(location);
        if (image != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        throw new FileNotFoundException(location.toString());
    }

    @Nonnull
    public InputStream func_195763_b(String fileName) throws IOException {
        return null;
    }

    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        if (location.func_110623_a().endsWith(".png")) {
            return this.getImageInputStream(location);
        }
        String state = this.blockStates.get(location);
        if (state != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(state.getBytes());
            return new ByteArrayInputStream(os.toByteArray());
        }
        throw new FileNotFoundException(location.toString());
    }

    public Collection<ResourceLocation> func_195758_a(ResourcePackType type, String pathIn, int maxDepth, Predicate<String> filter) {
        return ImmutableList.builder().addAll(this.images.keySet()).addAll(this.blockStates.keySet()).build();
    }

    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        return this.images.containsKey(location) || this.blockStates.containsKey(location);
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        return ImmutableSet.copyOf(this.domains);
    }

    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> deserializer) throws IOException {
        return null;
    }

    @Nonnull
    public String func_195762_a() {
        return "Overloaded Dynamic Textures";
    }

    public void close() throws IOException {
    }
}

