/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.render.item;

import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.ModItems;
import com.cjm721.overloaded.util.AssistMode;
import com.cjm721.overloaded.util.PlayerInteractionUtil;
import com.cjm721.overloaded.util.RenderUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="overloaded", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RenderMultiToolAssist {
    @SubscribeEvent
    public static void onMouseEvent(InputEvent.MouseInputEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
    }

    @SubscribeEvent
    public static void onKeyEvent(InputEvent.KeyInputEvent event) {
    }

    private static void changeHelpMode(int dwheel) {
        AssistMode[] values = AssistMode.values();
        int mode = (OverloadedConfig.INSTANCE.multiToolConfig.assistMode + Integer.signum(dwheel)) % values.length;
        if (mode < 0) {
            mode += values.length;
        }
        OverloadedConfig.INSTANCE.multiToolConfig.assistMode = mode;
    }

    @Nonnull
    public static AssistMode getAssistMode() {
        AssistMode[] values = AssistMode.values();
        int mode = OverloadedConfig.INSTANCE.multiToolConfig.assistMode;
        for (AssistMode assistMode : values) {
            if (assistMode.getMode() != mode) continue;
            return assistMode;
        }
        RenderMultiToolAssist.changeHelpMode(0);
        return AssistMode.NONE;
    }

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184614_ca().func_77973_b() != ModItems.multiTool) {
            return;
        }
        BlockRayTraceResult result = PlayerInteractionUtil.getBlockPlayerLookingAtClient((PlayerEntity)player, event.getPartialTicks());
        if (result == null) {
            return;
        }
        ItemStack stack = ModItems.multiTool.getSelectedBlockItemStack(player.func_184614_ca());
        BlockState state = stack.func_77973_b() instanceof BlockItem ? ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P() : Blocks.field_150347_e.func_176223_P();
        switch (RenderMultiToolAssist.getAssistMode()) {
            case PLACE_PREVIEW: {
                if (stack.func_190926_b()) break;
                RenderMultiToolAssist.renderBlockPreview(event, (PlayerEntity)player, stack, result, state);
                break;
            }
            case REMOVE_PREVIEW: {
                RenderMultiToolAssist.renderRemovePreview(event, (PlayerEntity)player, result);
                break;
            }
            case BOTH_PREVIEW: {
                if (!stack.func_190926_b()) {
                    RenderMultiToolAssist.renderBlockPreview(event, (PlayerEntity)player, stack, result, state);
                }
                RenderMultiToolAssist.renderRemovePreview(event, (PlayerEntity)player, result);
            }
        }
    }

    private static void renderRemovePreview(RenderWorldLastEvent event, PlayerEntity player, BlockRayTraceResult result) {
    }

    private static void renderBlockPreview(RenderWorldLastEvent event, PlayerEntity player, ItemStack stack, BlockRayTraceResult result, BlockState state) {
        BlockPos toRenderAt = result.func_216350_a().func_177971_a(result.func_216354_b().func_176730_m());
        float partialTicks = event.getPartialTicks();
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)((double)toRenderAt.func_177958_n() - x), (double)((double)toRenderAt.func_177956_o() - y - (double)player.func_213307_e(player.func_213283_Z())), (double)((double)toRenderAt.func_177952_p() - z));
        RenderUtil.renderGhostModel(stack, state, player.func_130014_f_(), toRenderAt);
        GlStateManager.popMatrix();
    }
}

