/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.basic.container;

import com.cjm721.overloaded.block.ModBlock;
import com.cjm721.overloaded.block.basic.container.AbstractBlockHyperContainer;
import com.cjm721.overloaded.client.render.dynamic.general.ResizeableTextureGenerator;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.storage.stacks.intint.LongEnergyStack;
import com.cjm721.overloaded.tile.infinity.TileAlmostInfiniteCapacitor;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockAlmostInfiniteCapacitor
extends AbstractBlockHyperContainer {
    public BlockAlmostInfiniteCapacitor() {
        super(ModBlock.getDefaultProperties());
        this.setRegistryName("almost_infinite_capacitor");
    }

    @Nonnull
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileAlmostInfiniteCapacitor();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), null);
        ResizeableTextureGenerator.addToTextureQueue(new ResizeableTextureGenerator.ResizableTexture(new ResourceLocation("overloaded", "textures/block/infinite_capacitor.png"), new ResourceLocation("overloaded", "textures/dynamic/blocks/infinite_capacitor.png"), OverloadedConfig.INSTANCE.textureResolutions.blockResolution));
    }

    @Override
    protected void sendPlayerStatus(World world, BlockPos pos, PlayerEntity player) {
        LongEnergyStack stack = ((TileAlmostInfiniteCapacitor)world.func_175625_s(pos)).getStorage().status();
        double percent = (double)stack.getAmount().longValue() / 9.223372036854776E18;
        player.func_146105_b((ITextComponent)new StringTextComponent(String.format("Energy Amount: %,d  %,.4f%%", stack.getAmount(), percent)), false);
    }
}

