/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.worldgen.mobevents;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireWall;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.mobevent.MobEventPlayerServer;
import com.lycanitesmobs.core.mobevent.effects.StructureBuilder;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class RahovartStructureBuilder
extends StructureBuilder {
    public RahovartStructureBuilder() {
        this.name = "rahovart";
    }

    @Override
    public void build(World world, PlayerEntity player, BlockPos pos, int level, int ticks) {
        int originX = pos.func_177958_n();
        int originY = pos.func_177956_o();
        int originZ = pos.func_177952_p();
        originX += 20;
        int height = 40;
        if (originY < 5) {
            originY = 5;
        }
        if (world.func_72940_L() <= height) {
            originY = 5;
        } else if (originY + height >= world.func_72940_L()) {
            originY = Math.max(5, world.func_72940_L() - height - 1);
        }
        if (ticks == 20) {
            this.buildArenaFloor(world, originX, originY, originZ);
        }
        if (ticks >= 60 && ticks % 10 == 0) {
            world.func_217385_a(null, (double)(originX - 20 + world.field_73012_v.nextInt(40)), (double)(originY + 25 + world.field_73012_v.nextInt(10)), (double)(originZ - 20 + world.field_73012_v.nextInt(40)), 2.0f, Explosion.Mode.NONE);
        }
        if (ticks == 200) {
            this.buildObstacles(world, originX, originY, originZ);
        }
        if (ticks == 500) {
            for (int i = 0; i < 5; ++i) {
                EntityHellfireWall entityProjectileBase = new EntityHellfireWall(ProjectileManager.getInstance().oldProjectileTypes.get(EntityHellfireWall.class), world, originX, originY + 10 * i, originZ);
                entityProjectileBase.projectileLife = 180;
                world.func_217376_c((Entity)entityProjectileBase);
            }
        }
        if (ticks == 580) {
            MobEventPlayerServer mobEventPlayerServer;
            EntityCreatureBase entityCreatureBase = (EntityCreatureBase)CreatureManager.getInstance().getCreature("rahovart").createEntity(world);
            entityCreatureBase.func_70012_b(originX, originY + 1, originZ, 0.0f, 0.0f);
            world.func_217376_c((Entity)entityCreatureBase);
            entityCreatureBase.setArenaCenter(new BlockPos(originX, originY + 1, originZ));
            ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
            if (worldExt != null && (mobEventPlayerServer = worldExt.getMobEventPlayerServer(this.name)) != null) {
                mobEventPlayerServer.mobEvent.onSpawn((LivingEntity)entityCreatureBase, world, player, pos, level, ticks);
            }
        }
    }

    public void buildArenaFloor(World world, int originX, int originY, int originZ) {
        double rubbleChance = 0.01;
        int radius = 60;
        int height = 40;
        Block primaryBlock = ObjectManager.getBlock("demonstonetile");
        Block secondaryBlock = ObjectManager.getBlock("demoncrystal");
        double secondaryChance = 0.05;
        int stripNumber = 1;
        for (int x = originX - radius; x < originX + radius; ++x) {
            float stripNormal = (float)stripNumber / (float)radius;
            if (stripNumber > radius) {
                stripNormal = (float)(radius - (stripNumber - radius)) / (float)radius;
            }
            int stripRadius = Math.round((float)radius * (float)Math.sin(Math.toRadians(90.0f * stripNormal)));
            for (int z = originZ - stripRadius; z < originZ + stripRadius; ++z) {
                int y = originY;
                Block buildBlock = primaryBlock;
                if (world.field_73012_v.nextDouble() <= secondaryChance) {
                    buildBlock = secondaryBlock;
                }
                world.func_180501_a(new BlockPos(x, y, z), buildBlock.func_176223_P(), 2);
                world.func_180501_a(new BlockPos(x, y - 1, z), buildBlock.func_176223_P(), 2);
                world.func_180501_a(new BlockPos(x, y - 2, z), buildBlock.func_176223_P(), 2);
                ++y;
                while (y <= originY + height && y < world.func_72940_L()) {
                    world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
                    ++y;
                }
            }
            ++stripNumber;
        }
    }

    public void buildObstacles(World world, int originX, int originY, int originZ) {
        double angle = 0.0;
        int radius = 50;
        ArrayList<int[]> decorationCoords = new ArrayList<int[]>();
        while (angle < 360.0) {
            double angleRadians = Math.toRadians(angle += 5.0 + 5.0 * world.field_73012_v.nextDouble());
            double x = (double)radius * Math.cos(angleRadians) - Math.sin(angleRadians);
            double z = (double)radius * Math.sin(angleRadians) + Math.cos(angleRadians);
            decorationCoords.add(this.buildPillar(world, originX + (int)Math.ceil(x), originY, originZ + (int)Math.ceil(z)));
        }
        for (int[] decorationCoord : decorationCoords) {
            this.buildDecoration(world, decorationCoord[0], decorationCoord[1], decorationCoord[2]);
        }
    }

    public int[] buildPillar(World world, int originX, int originY, int originZ) {
        int radiusMax = 5;
        int height = 20 + Math.round(20.0f * world.field_73012_v.nextFloat());
        Block primaryBlock = ObjectManager.getBlock("demonstonebrick");
        Block secondaryBlock = ObjectManager.getBlock("demonstone");
        Block tetriaryBlock = ObjectManager.getBlock("demonstonechiseled");
        Block pillarBlock = ObjectManager.getBlock("demonstonepillar");
        double secondaryChance = 0.4;
        double tetriaryChance = 0.05;
        int[] decorationCoord = new int[]{originX, originY, originZ};
        int radius = radiusMax;
        int radiusHeight = radiusMax;
        for (int y = originY; y <= originY + height; ++y) {
            if (y <= originY + radiusMax * radiusMax) {
                int stripNumber = 1;
                for (int x = originX - radius; x <= originX + radius; ++x) {
                    float stripNormal = (float)stripNumber / (float)radius;
                    if (stripNumber > radius) {
                        stripNormal = (float)(radius - (stripNumber - radius)) / (float)radius;
                    }
                    int stripRadius = Math.round((float)radius * (float)Math.sin(Math.toRadians(90.0f * stripNormal)));
                    for (int z = originZ - stripRadius; z <= originZ + stripRadius; ++z) {
                        if (x == originX && z == originZ) {
                            world.func_180501_a(new BlockPos(x, y, z), pillarBlock.func_176223_P(), 2);
                            continue;
                        }
                        if (world.field_73012_v.nextDouble() > secondaryChance) {
                            world.func_180501_a(new BlockPos(x, y, z), primaryBlock.func_176223_P(), 2);
                            continue;
                        }
                        if (world.field_73012_v.nextDouble() > tetriaryChance) {
                            world.func_180501_a(new BlockPos(x, y, z), secondaryBlock.func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a(new BlockPos(x, y, z), tetriaryBlock.func_176223_P(), 2);
                    }
                    ++stripNumber;
                }
            } else {
                world.func_180501_a(new BlockPos(originX, y, originZ), pillarBlock.func_176223_P(), 2);
                decorationCoord = new int[]{originX, y, originZ};
            }
            if (--radiusHeight > 0) continue;
            radiusHeight = radiusMax;
            --radius;
        }
        return decorationCoord;
    }

    public void buildDecoration(World world, int originX, int originY, int originZ) {
        Block primaryBlock = Blocks.field_150343_Z;
        Block hazardBlock = ObjectManager.getBlock("hellfire");
        world.func_180501_a(new BlockPos(originX, originY + 1, originZ), primaryBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX, originY + 2, originZ), primaryBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX, originY + 3, originZ), hazardBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX + 1, originY + 1, originZ), primaryBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX + 1, originY + 2, originZ), hazardBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX - 1, originY + 1, originZ), primaryBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX - 1, originY + 2, originZ), hazardBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX, originY + 1, originZ + 1), primaryBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX, originY + 2, originZ + 1), hazardBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX, originY + 1, originZ - 1), primaryBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX, originY + 2, originZ - 1), hazardBlock.func_176223_P(), 2);
    }
}

