/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.tileentity;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.block.BlockSummoningPedestal;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityPortal;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.network.MessageSummoningPedestalStats;
import com.lycanitesmobs.core.network.MessageSummoningPedestalSummonSet;
import com.lycanitesmobs.core.pets.SummonSet;
import com.lycanitesmobs.core.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TileEntitySummoningPedestal
extends TileEntityBase
implements IInventory {
    public long updateTick = 0L;
    public EntityPortal summoningPortal;
    public UUID ownerUUID;
    public String ownerName = "";
    public SummonSet summonSet;
    public int summonAmount = 1;
    public int capacityCharge = 100;
    public int capacity = 0;
    public int capacityMax = this.capacityCharge * 10;
    public int summonProgress = 0;
    public int summonProgressMax = 180;
    public String inventoryName = "";
    public NonNullList<ItemStack> itemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public int summoningFuel = 0;
    public int summoningFuelMax = 12000;
    public int summoningFuelAmount = 12000;
    public List<EntityCreatureBase> minions = new ArrayList<EntityCreatureBase>();
    protected String[] loadMinionIDs;
    protected boolean blockStateSet = false;

    @Override
    public void func_145843_s() {
        if (this.summoningPortal != null && this.summoningPortal.func_70089_S()) {
            this.summoningPortal.func_70106_y();
        }
        super.func_145843_s();
    }

    @Override
    public void func_73660_a() {
        LycanitesMobs.logInfo("", "Summoning Pedestal Alive!");
        if (this.func_145831_w().field_72995_K) {
            if (this.summoningFuel > 0) {
                if (this.summonProgress >= this.summonProgressMax) {
                    this.summonProgress = 0;
                } else if (this.summonProgress > 0) {
                    ++this.summonProgress;
                }
            }
            return;
        }
        if (this.loadMinionIDs != null) {
            int range = 20;
            List nearbyEntities = this.func_145831_w().func_217357_a(EntityCreatureBase.class, new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - range), (double)(this.func_174877_v().func_177956_o() - range), (double)(this.func_174877_v().func_177952_p() - range), (double)(this.func_174877_v().func_177958_n() + range), (double)(this.func_174877_v().func_177956_o() + range), (double)(this.func_174877_v().func_177952_p() + range)));
            block2: for (EntityCreatureBase possibleEntity : nearbyEntities) {
                for (String loadMinionID : this.loadMinionIDs) {
                    UUID uuid = null;
                    try {
                        uuid = UUID.fromString(loadMinionID);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!possibleEntity.func_110124_au().equals(uuid)) continue;
                    this.minions.add(possibleEntity);
                    continue block2;
                }
            }
            this.loadMinionIDs = null;
        }
        if (this.summonSet != null && this.summonSet.getCreatureInfo() != null) {
            if (this.summonSet.getFollowing()) {
                this.summonSet.following = false;
            }
            if (this.summoningPortal == null || !this.summoningPortal.func_70089_S()) {
                this.summoningPortal = new EntityPortal(ProjectileManager.getInstance().oldProjectileTypes.get(EntityPortal.class), this.func_145831_w(), this);
                this.summoningPortal.setProjectileScale(8.0f);
                this.func_145831_w().func_217376_c((Entity)this.summoningPortal);
            }
            if (this.updateTick % 100L == 0L) {
                this.capacity = 0;
                for (EntityCreatureBase minion : this.minions.toArray(new EntityCreatureBase[this.minions.size()])) {
                    if (minion == null || !minion.func_70089_S()) {
                        this.minions.remove((Object)minion);
                        continue;
                    }
                    this.capacity += minion.creatureInfo.summonCost * this.capacityCharge;
                }
            }
            if (this.capacity + this.summonSet.getCreatureInfo().summonCost > this.capacityMax) {
                this.summonProgress = 0;
            } else {
                ItemStack fuelStack;
                if (this.summoningFuel <= 0 && !(fuelStack = this.func_70301_a(0)).func_190926_b()) {
                    int refuel = this.summoningFuelAmount;
                    if (fuelStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150451_bX)) {
                        refuel = this.summoningFuelAmount * 9;
                    }
                    fuelStack.func_77979_a(1);
                    this.summoningFuel = refuel;
                    this.summoningFuelMax = refuel;
                }
                if (this.summoningFuel > 0) {
                    --this.summoningFuel;
                    if (this.summonProgress++ >= this.summonProgressMax) {
                        this.summoningPortal.summonCreatures();
                        this.summonProgress = 0;
                        this.capacity = Math.min(this.capacity + this.capacityCharge * this.summonSet.getCreatureInfo().summonCost, this.capacityMax);
                    }
                }
            }
        }
        if (!this.blockStateSet) {
            if (!"".equals(this.getOwnerName())) {
                BlockSummoningPedestal.setState(BlockSummoningPedestal.EnumSummoningPedestal.PLAYER, this.func_145831_w(), this.func_174877_v());
            } else {
                BlockSummoningPedestal.setState(BlockSummoningPedestal.EnumSummoningPedestal.NONE, this.func_145831_w(), this.func_174877_v());
            }
            this.blockStateSet = true;
        }
        if (this.updateTick % 20L == 0L) {
            MessageSummoningPedestalStats message = new MessageSummoningPedestalStats(this.capacity, this.summonProgress, this.summoningFuel, this.summoningFuelMax, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            LycanitesMobs.packetHandler.sendToAllAround(message, this.func_145831_w(), new Vec3d((Vec3i)this.func_174877_v()), 5.0);
        }
        ++this.updateTick;
    }

    public void setOwner(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity entityPlayer = (PlayerEntity)entity;
            this.ownerUUID = entityPlayer.func_110124_au();
            this.ownerName = entity.func_200200_C_().toString();
        }
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    @Nullable
    public PlayerEntity getPlayer() {
        if (this.ownerUUID == null) {
            return null;
        }
        return this.func_145831_w().func_217371_b(this.ownerUUID);
    }

    @Nullable
    public Class getSummonClass() {
        if (this.summonSet == null) {
            return null;
        }
        return this.summonSet.getCreatureClass();
    }

    public void setSummonSet(SummonSet summonSet) {
        if (this.getPlayer() != null && !summonSet.isUseable()) {
            return;
        }
        this.summonSet = new SummonSet(null);
        this.summonSet.setSummonType(summonSet.summonType);
        this.summonSet.sitting = summonSet.getSitting();
        this.summonSet.following = false;
        this.summonSet.passive = summonSet.getPassive();
        this.summonSet.aggressive = summonSet.getAggressive();
        this.summonSet.pvp = summonSet.getPVP();
    }

    public void applyMinionBehaviour(EntityCreatureTameable minion) {
        if (this.summonSet != null) {
            this.summonSet.applyBehaviour(minion);
            minion.applySubspecies(this.summonSet.subspecies);
        }
        this.minions.add(minion);
        minion.setHome(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), 20.0f);
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.itemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.itemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.itemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70302_i_() {
        return this.itemStacks.size();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return false;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack itemStack) {
        return itemStack.func_77973_b() == Items.field_151137_ax || itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150451_bX);
    }

    public void func_174888_l() {
    }

    public ITextComponent getName() {
        return new TranslationTextComponent(this.inventoryName, new Object[0]);
    }

    public boolean hasCustomName() {
        return !"".equals(this.inventoryName);
    }

    @Override
    public boolean func_145842_c(int eventID, int eventArg) {
        return false;
    }

    @Override
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT syncData = new CompoundNBT();
        if (this.summonSet != null) {
            CompoundNBT summonSetNBT = new CompoundNBT();
            this.summonSet.write(summonSetNBT);
            syncData.func_218657_a("SummonSet", (INBT)summonSetNBT);
        }
        if (!this.func_145831_w().field_72995_K && this.getOwnerUUID() != null && this.getOwnerName() != null) {
            syncData.func_74778_a("OwnerUUID", this.getOwnerUUID().toString());
            syncData.func_74778_a("OwnerName", this.getOwnerName());
            syncData.func_74778_a("InventoryName", this.inventoryName);
        }
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, syncData);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        if (!this.func_145831_w().field_72995_K) {
            return;
        }
        CompoundNBT syncData = packet.func_148857_g();
        if (syncData.func_74764_b("OwnerUUID")) {
            this.ownerUUID = UUID.fromString(syncData.func_74779_i("OwnerUUID"));
        }
        if (syncData.func_74764_b("OwnerName")) {
            this.ownerName = syncData.func_74779_i("OwnerName");
        }
        if (syncData.func_74764_b("InventoryName")) {
            this.inventoryName = syncData.func_74779_i("InventoryName");
        }
        if (syncData.func_74764_b("SummonSet")) {
            SummonSet summonSet = new SummonSet(null);
            summonSet.read(syncData.func_74775_l("SummonSet"));
            this.summonSet = summonSet;
        }
    }

    public void sendSummonSetToServer(SummonSet summonSet) {
        LycanitesMobs.packetHandler.sendToServer(new MessageSummoningPedestalSummonSet(summonSet, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTagCompound) {
        String uuidString;
        super.func_145839_a(nbtTagCompound);
        this.ownerUUID = nbtTagCompound.func_74764_b("OwnerUUID") ? (!"".equals(uuidString = nbtTagCompound.func_74779_i("OwnerUUID")) ? UUID.fromString(uuidString) : null) : null;
        this.ownerName = nbtTagCompound.func_74764_b("OwnerName") ? nbtTagCompound.func_74779_i("OwnerName") : "";
        if (nbtTagCompound.func_74764_b("SummonSet")) {
            CompoundNBT summonSetNBT = nbtTagCompound.func_74775_l("SummonSet");
            SummonSet summonSet = new SummonSet(null);
            summonSet.read(summonSetNBT);
            this.summonSet = summonSet;
        } else {
            this.summonSet = null;
        }
        if (nbtTagCompound.func_74764_b("MinionIDs")) {
            ListNBT minionIDs = nbtTagCompound.func_150295_c("MinionIDs", 10);
            this.loadMinionIDs = new String[minionIDs.size()];
            for (int i = 0; i < minionIDs.size(); ++i) {
                CompoundNBT minionID = minionIDs.func_150305_b(i);
                if (!minionID.func_74764_b("ID")) continue;
                this.loadMinionIDs[i] = minionID.func_74779_i("ID");
            }
        }
        if (nbtTagCompound.func_74764_b("Fuel")) {
            this.summoningFuel = nbtTagCompound.func_74762_e("Fuel");
        }
        if (nbtTagCompound.func_74764_b("FuelMax")) {
            this.summoningFuelMax = nbtTagCompound.func_74762_e("FuelMax");
        }
        if (nbtTagCompound.func_74764_b("Items")) {
            NonNullList itemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)nbtTagCompound, (NonNullList)itemStacks);
            for (int i = 0; i < itemStacks.size(); ++i) {
                if (i >= this.func_70302_i_()) continue;
                ItemStack itemStack = (ItemStack)itemStacks.get(i);
                if (itemStack.func_190926_b()) {
                    this.func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                this.func_70299_a(i, itemStack);
            }
        }
        super.func_145839_a(nbtTagCompound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        if (this.ownerUUID == null) {
            nbtTagCompound.func_74778_a("OwnerUUID", "");
        } else {
            nbtTagCompound.func_74778_a("OwnerUUID", this.ownerUUID.toString());
        }
        if (this.summonSet != null) {
            CompoundNBT summonSetNBT = new CompoundNBT();
            this.summonSet.write(summonSetNBT);
            nbtTagCompound.func_218657_a("SummonSet", (INBT)summonSetNBT);
        }
        nbtTagCompound.func_74778_a("OwnerName", this.ownerName);
        if (this.minions.size() > 0) {
            ListNBT minionIDs = new ListNBT();
            for (LivingEntity livingEntity : this.minions) {
                CompoundNBT minionID = new CompoundNBT();
                minionID.func_74778_a("ID", livingEntity.func_110124_au().toString());
                minionIDs.add((Object)minionID);
            }
            nbtTagCompound.func_218657_a("MinionIDs", (INBT)minionIDs);
        }
        nbtTagCompound.func_74768_a("Fuel", this.summoningFuel);
        nbtTagCompound.func_74768_a("FuelMax", this.summoningFuelMax);
        ItemStackHelper.func_191282_a((CompoundNBT)nbtTagCompound, this.itemStacks);
        return nbtTagCompound;
    }
}

