/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.condition;

import com.google.gson.JsonObject;
import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.spawner.condition.SpawnCondition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class PlayerSpawnCondition
extends SpawnCondition {
    public String username = "";
    public String uuid = "";
    public float difficultyMin = -1.0f;
    public float difficultyMax = -1.0f;
    public int levelMin = -1;
    public int levelMax = -1;
    public int timeMin = -1;
    public int timeMax = -1;
    public int lightLevelMin = -1;
    public int lightLevelMax = -1;
    public boolean grounded = false;
    public boolean notGrounded = false;
    public boolean inWater = false;
    public boolean notInWater = false;
    public List<Item> heldItems = new ArrayList<Item>();
    public String heldItemsListType = "blacklist";

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("username")) {
            this.username = json.get("username").getAsString();
        }
        if (json.has("uuid")) {
            this.uuid = json.get("uuid").getAsString();
        }
        if (json.has("difficultyMin")) {
            this.difficultyMin = json.get("difficultyMin").getAsFloat();
        }
        if (json.has("difficultyMax")) {
            this.difficultyMax = json.get("difficultyMax").getAsFloat();
        }
        if (json.has("levelMin")) {
            this.levelMin = json.get("levelMin").getAsInt();
        }
        if (json.has("levelMax")) {
            this.levelMax = json.get("levelMax").getAsInt();
        }
        if (json.has("timeMin")) {
            this.timeMin = json.get("timeMin").getAsInt();
        }
        if (json.has("timeMax")) {
            this.timeMax = json.get("timeMax").getAsInt();
        }
        if (json.has("lightLevelMin")) {
            this.lightLevelMin = json.get("lightLevelMin").getAsInt();
        }
        if (json.has("lightLevelMax")) {
            this.lightLevelMax = json.get("lightLevelMax").getAsInt();
        }
        if (json.has("grounded")) {
            this.grounded = json.get("grounded").getAsBoolean();
        }
        if (json.has("notGrounded")) {
            this.notGrounded = json.get("notGrounded").getAsBoolean();
        }
        if (json.has("inWater")) {
            this.inWater = json.get("inWater").getAsBoolean();
        }
        if (json.has("notInWater")) {
            this.notInWater = json.get("notInWater").getAsBoolean();
        }
        if (json.has("heldItems")) {
            this.heldItems = JSONHelper.getJsonItems(json.get("heldItems").getAsJsonArray());
        }
        if (json.has("heldItemsListType")) {
            this.heldItemsListType = json.get("heldItemsListType").getAsString();
        }
        super.loadFromJSON(json);
    }

    @Override
    public boolean isMet(World world, PlayerEntity player, BlockPos position) {
        if (player == null) {
            return false;
        }
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (!"".equals(this.username) && !this.username.equalsIgnoreCase(player.func_200200_C_().toString())) {
            return false;
        }
        if (!"".equals(this.uuid) && !this.uuid.equalsIgnoreCase(player.func_110124_au().toString())) {
            return false;
        }
        if (this.difficultyMin >= 0.0f || this.difficultyMax >= 0.0f) {
            DifficultyInstance difficultyInstance = world.func_175649_E(player.func_180425_c());
            float difficulty = difficultyInstance.func_180168_b();
            if (this.difficultyMin >= 0.0f && difficulty < this.difficultyMin) {
                return false;
            }
            if (this.difficultyMax >= 0.0f && difficulty > this.difficultyMax) {
                return false;
            }
        }
        if (this.levelMin >= 0 && player.field_71068_ca < this.levelMin) {
            return false;
        }
        if (this.levelMax >= 0 && player.field_71068_ca > this.levelMax) {
            return false;
        }
        if (this.grounded && !player.field_70122_E) {
            return false;
        }
        if (this.notGrounded && player.field_70122_E) {
            return false;
        }
        if (this.inWater && !player.func_70090_H()) {
            return false;
        }
        if (this.notInWater && player.func_70090_H()) {
            return false;
        }
        if (playerExt != null) {
            if (this.timeMin >= 0 && playerExt.timePlayed < (long)this.timeMin) {
                return false;
            }
            if (this.timeMax >= 0 && playerExt.timePlayed > (long)this.timeMax) {
                return false;
            }
        }
        int lightLevel = world.func_201696_r(player.func_180425_c());
        if (this.lightLevelMin >= 0 && lightLevel < this.lightLevelMin) {
            return false;
        }
        if (this.lightLevelMax >= 0 && lightLevel > this.lightLevelMax) {
            return false;
        }
        if (this.heldItems.size() > 0) {
            boolean holdingItem = false;
            if (!player.func_184614_ca().func_190926_b() && this.heldItems.contains(player.func_184614_ca().func_77973_b())) {
                holdingItem = true;
                if ("blacklist".equalsIgnoreCase(this.heldItemsListType)) {
                    return false;
                }
            }
            if (!player.func_184592_cb().func_190926_b() && this.heldItems.contains(player.func_184592_cb().func_77973_b())) {
                holdingItem = true;
                if ("blacklist".equalsIgnoreCase(this.heldItemsListType)) {
                    return false;
                }
            }
            if (!holdingItem && "whitelist".equalsIgnoreCase(this.heldItemsListType)) {
                return false;
            }
        } else if ("whitelist".equalsIgnoreCase(this.heldItemsListType)) {
            return false;
        }
        return super.isMet(world, player, position);
    }
}

