/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.renderer.layer.specific;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.renderer.RenderCreature;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureBase;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerDjinn
extends LayerCreatureBase {
    public LayerDjinn(RenderCreature renderer) {
        super(renderer);
    }

    @Override
    public boolean canRenderPart(String partName, EntityCreatureBase entity, boolean trophy) {
        return partName.contains("ribbon");
    }

    @Override
    public ResourceLocation getLayerTexture(EntityCreatureBase entity) {
        String textureName = entity.getTextureName();
        if (entity.getSubspecies() != null) {
            textureName = textureName + "_" + entity.getSubspecies().color;
        }
        if (AssetManager.getTexture(textureName = textureName + "_ribbon") == null) {
            AssetManager.addTexture(textureName, entity.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    @Override
    public Vector2f getTextureOffset(String partName, EntityCreatureBase entity, boolean trophy, float loop) {
        return new Vector2f(-loop * 25.0f, 0.0f);
    }

    @Override
    public Vector4f getPartColor(String partName, EntityCreatureBase entity, boolean trophy) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 0.75f);
    }

    @Override
    public void onRenderStart(Entity entity, boolean trophy) {
    }

    @Override
    public void onRenderFinish(Entity entity, boolean trophy) {
    }
}

