/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.renderer.layer;

import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.renderer.RenderProjectileModel;
import com.lycanitesmobs.core.renderer.layer.LayerProjectileBase;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerProjectileEffect
extends LayerProjectileBase {
    public String textureSuffix;
    public boolean subspecies = true;
    public boolean glow = false;
    public int blending = 0;
    public Vector2f scrollSpeed;

    public LayerProjectileEffect(RenderProjectileModel renderer, String textureSuffix) {
        super(renderer);
        this.name = textureSuffix;
        this.textureSuffix = textureSuffix;
    }

    public LayerProjectileEffect(RenderProjectileModel renderer, String textureSuffix, boolean glow, int blending, boolean subspecies) {
        super(renderer);
        this.name = textureSuffix;
        this.textureSuffix = textureSuffix;
        this.glow = glow;
        this.blending = blending;
        this.subspecies = subspecies;
    }

    @Override
    public Vector4f getPartColor(String partName, EntityProjectileBase entity, boolean trophy) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public ResourceLocation getLayerTexture(EntityProjectileBase entity) {
        return super.getLayerTexture(entity);
    }

    @Override
    public void onRenderStart(Entity entity) {
        int i = entity.func_70070_b();
        if (this.glow) {
            GlStateManager.disableLighting();
            i = 0xF000F0;
        }
        int j = i % 65536;
        int k = i / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
        if (this.blending == BLEND.ADD.id) {
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        } else if (this.blending == BLEND.SUB.id) {
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    }

    @Override
    public void onRenderFinish(Entity entity) {
        if (this.glow) {
            GlStateManager.enableLighting();
        }
    }

    @Override
    public Vector2f getTextureOffset(String partName, EntityProjectileBase entity, boolean trophy, float loop) {
        if (this.scrollSpeed == null) {
            this.scrollSpeed = new Vector2f(0.0f, 0.0f);
        }
        return new Vector2f(loop * this.scrollSpeed.x, loop * this.scrollSpeed.y);
    }

    public static enum BLEND {
        NORMAL(0),
        ADD(1),
        SUB(2);

        public final int id;

        private BLEND(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }
}

