/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.renderer.layer;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.renderer.RenderCreature;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureBase;
import com.mojang.blaze3d.platform.GLX;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerCreatureGlow
extends LayerCreatureBase {
    public LayerCreatureGlow(RenderCreature renderer) {
        super(renderer);
    }

    @Override
    public Vector4f getPartColor(String partName, EntityCreatureBase entity, boolean trophy) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public ResourceLocation getLayerTexture(EntityCreatureBase entity) {
        String textureName = entity.getTextureName();
        if (entity.getSubspecies() != null) {
            textureName = textureName + "_" + entity.getSubspecies().color;
        }
        if (AssetManager.getTexture(textureName = textureName + "_glow") == null) {
            AssetManager.addTexture(textureName, entity.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    @Override
    public void onRenderStart(Entity entity, boolean trophy) {
        int i = 0xF000F0;
        int j = i % 65536;
        int k = i / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
    }

    @Override
    public void onRenderFinish(Entity entity, boolean trophy) {
        int i = entity.func_70070_b();
        int j = i % 65536;
        int k = i / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
    }
}

