/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.renderer;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityProjectileCustom;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.model.EquipmentPartModelLoader;
import com.lycanitesmobs.core.model.projectile.ModelAetherwave;
import com.lycanitesmobs.core.model.projectile.ModelChaosOrb;
import com.lycanitesmobs.core.model.projectile.ModelCrystalShard;
import com.lycanitesmobs.core.model.projectile.ModelLightBall;
import com.lycanitesmobs.core.renderer.RenderFactoryCreature;
import com.lycanitesmobs.core.renderer.RenderFactoryNone;
import com.lycanitesmobs.core.renderer.RenderFactoryProjectile;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class RenderRegister {
    public void registerModels() {
        AssetManager.registerOldProjectileModel("lightball", ModelLightBall.class);
        AssetManager.registerOldProjectileModel("crystalshard", ModelCrystalShard.class);
        AssetManager.registerOldProjectileModel("aetherwave", ModelAetherwave.class);
        AssetManager.registerOldProjectileModel("chaosorb", ModelChaosOrb.class);
    }

    public void registerModelLoaders() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new EquipmentPartModelLoader());
    }

    public void registerRenderFactories() {
        Class<? extends Entity> projectileClass;
        for (CreatureInfo creatureInfo : CreatureManager.getInstance().creatures.values()) {
            if (creatureInfo.dummy) {
                RenderingRegistry.registerEntityRenderingHandler(creatureInfo.entityClass, new RenderFactoryNone(creatureInfo.entityClass));
            }
            RenderingRegistry.registerEntityRenderingHandler(creatureInfo.entityClass, new RenderFactoryCreature(creatureInfo));
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectileCustom.class, new RenderFactoryProjectile());
        for (String string : ProjectileManager.getInstance().oldSpriteProjectiles.keySet()) {
            projectileClass = ProjectileManager.getInstance().oldSpriteProjectiles.get(string);
            RenderingRegistry.registerEntityRenderingHandler(projectileClass, new RenderFactoryProjectile(string, projectileClass, false));
        }
        for (String string : ProjectileManager.getInstance().oldModelProjectiles.keySet()) {
            projectileClass = ProjectileManager.getInstance().oldModelProjectiles.get(string);
            RenderingRegistry.registerEntityRenderingHandler(projectileClass, new RenderFactoryProjectile(string, projectileClass, true));
        }
        for (Class clazz : ObjectManager.specialEntities.values()) {
            RenderingRegistry.registerEntityRenderingHandler((Class)clazz, new RenderFactoryNone(clazz));
        }
    }
}

