/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.renderer;

import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.entity.EntityProjectileCustom;
import com.lycanitesmobs.core.entity.EntityProjectileLaser;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderProjectileSprite
extends EntityRenderer<EntityProjectileBase> {
    private int renderTime = 0;
    Class projectileClass;
    protected Model laserModel = new Model(){};
    private RendererModel laserBox;

    public RenderProjectileSprite(EntityRendererManager renderManager, Class projectileClass) {
        super(renderManager);
        this.projectileClass = projectileClass;
    }

    public void doRender(EntityProjectileBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (this.renderTime++ > 0x7FFFFFFE) {
            this.renderTime = 0;
        }
        this.renderProjectile(entity, x, y, z, entityYaw, partialTicks);
        if (entity instanceof EntityProjectileLaser) {
            this.renderLaser((EntityProjectileLaser)entity, x, y, z, entityYaw, partialTicks);
        }
    }

    public void renderProjectile(EntityProjectileBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        double scale = 0.5;
        if (entity instanceof EntityProjectileCustom && ((EntityProjectileCustom)entity).projectileInfo == null) {
            return;
        }
        if (entity != null) {
            scale *= (double)entity.getProjectileScale();
            y += (double)entity.getTextureOffsetY();
        }
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.enableRescaleNormal();
        GlStateManager.scaled((double)scale, (double)scale, (double)scale);
        this.func_110776_a(this.getEntityTexture(entity));
        this.renderTexture(Tessellator.func_178181_a(), entity);
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
    }

    private void renderTexture(Tessellator tessellator, EntityProjectileBase entity) {
        double minU = 0.0;
        double maxU = 1.0;
        double minV = 0.0;
        double maxV = 1.0;
        double textureWidth = 0.5;
        double textureHeight = 0.5;
        double offsetY = 0.0;
        if (entity != null && entity.animationFrameMax > 0) {
            minV = (float)entity.animationFrame / (float)entity.animationFrameMax;
            maxV = minV + (double)(1.0f / (float)entity.animationFrameMax);
            textureWidth *= (double)entity.textureScale;
            textureHeight *= (double)entity.textureScale;
            offsetY = entity.textureOffsetY;
        }
        GlStateManager.rotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)entity));
        }
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        vertexbuffer.func_181662_b(-textureWidth, -textureHeight + textureHeight / 2.0 + offsetY, 0.0).func_187315_a(minU, maxV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(textureWidth, -textureHeight + textureHeight / 2.0 + offsetY, 0.0).func_187315_a(maxU, maxV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(textureWidth, textureHeight + textureHeight / 2.0 + offsetY, 0.0).func_187315_a(maxU, minV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(-textureWidth, textureHeight + textureHeight / 2.0 + offsetY, 0.0).func_187315_a(minU, minV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    public void renderLaser(EntityProjectileLaser entity, double x, double y, double z, float par8, float par9) {
        float scale = entity.getLaserWidth();
        if (this.laserBox == null) {
            this.laserBox = new RendererModel(this.laserModel, 0, 0);
            this.laserBox.func_78789_a(-(scale / 2.0f), -(scale / 2.0f), 0.0f, (int)scale, (int)scale, 16);
            this.laserBox.field_78800_c = 0.0f;
            this.laserBox.field_78797_d = 0.0f;
            this.laserBox.field_78798_e = 0.0f;
        }
        float factor = 0.0625f;
        float lastSegment = 0.0f;
        float laserSize = entity.getLength();
        if (laserSize <= 0.0f) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableAlphaTest();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)entity.getLaserAlpha());
        GlStateManager.translated((double)x, (double)y, (double)z);
        this.func_110776_a(this.getLaserTexture(entity));
        float[] angles = entity.getBeamAngles();
        GlStateManager.rotatef((float)angles[1], (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)angles[3], (float)1.0f, (float)0.0f, (float)0.0f);
        for (float segment = 0.0f; segment <= laserSize - 1.0f; segment += 1.0f) {
            this.laserBox.func_78785_a(factor);
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)1.0f);
            lastSegment = segment;
        }
        GlStateManager.scalef((float)(laserSize - (lastSegment += 1.0f)), (float)1.0f, (float)1.0f);
        this.laserBox.func_78785_a(factor);
        GlStateManager.popMatrix();
    }

    protected ResourceLocation getEntityTexture(EntityProjectileBase entity) {
        return entity.getTexture();
    }

    protected ResourceLocation getLaserTexture(EntityProjectileLaser entity) {
        return entity.getBeamTexture();
    }
}

