/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.renderer;

import com.google.common.collect.Lists;
import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.model.ModelProjectileBase;
import com.lycanitesmobs.core.model.ModelProjectileObj;
import com.lycanitesmobs.core.renderer.layer.LayerProjectileBase;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderProjectileModel
extends EntityRenderer<EntityProjectileBase>
implements IEntityRenderer<EntityProjectileBase, ModelProjectileBase> {
    protected ModelProjectileBase renderModel;
    protected ModelProjectileBase defaultModel;
    protected final List<LayerRenderer<EntityProjectileBase, ModelProjectileBase>> renderLayers = Lists.newArrayList();

    public RenderProjectileModel(String entityID, EntityRendererManager renderManager) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        super(renderManager);
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(entityID);
        this.renderModel = projectileInfo != null ? AssetManager.getProjectileModel(projectileInfo) : AssetManager.getOldProjectileModel(entityID);
        if (this.renderModel == null) {
            return;
        }
        this.defaultModel = this.renderModel;
        this.renderModel.addCustomLayers(this);
    }

    public void doRender(EntityProjectileBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        GlStateManager.disableCull();
        try {
            GlStateManager.enableAlphaTest();
            if (!this.bindEntityTexture(entity)) {
                return;
            }
            GlStateManager.translatef((float)((float)x), (float)((float)y - 0.25f), (float)((float)z));
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.rotatef((float)entity.field_70177_z, (float)0.0f, (float)1.0f, (float)0.0f);
            if (!(this.renderModel instanceof ModelProjectileObj)) {
                this.renderModel.render(entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 1.0f);
            } else {
                ((ModelProjectileObj)this.renderModel).generateAnimationFrames(entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 1.0f);
                for (LayerRenderer<EntityProjectileBase, ModelProjectileBase> renderLayer : this.renderLayers) {
                    if (!(renderLayer instanceof LayerProjectileBase)) continue;
                    this.renderModel.render(entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 1.0f, (LayerProjectileBase)renderLayer, false);
                }
                ((ModelProjectileObj)this.renderModel).clearAnimationFrames();
            }
            GlStateManager.depthMask((boolean)true);
            GlStateManager.disableRescaleNormal();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
        GlStateManager.enableTexture();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
    }

    public ModelProjectileBase getMainModel() {
        return this.renderModel;
    }

    public ModelProjectileBase getEntityModel() {
        return this.getMainModel();
    }

    public final boolean addLayer(LayerRenderer<EntityProjectileBase, ModelProjectileBase> layer) {
        return this.renderLayers.add(layer);
    }

    protected boolean bindEntityTexture(EntityProjectileBase entity) {
        ResourceLocation texture = this.getEntityTexture(entity);
        if (texture == null) {
            return false;
        }
        this.func_110776_a(texture);
        return true;
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityProjectileBase entity) {
        return entity.getTexture();
    }
}

