/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.renderer;

import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.entity.EntityProjectileCustom;
import com.lycanitesmobs.core.renderer.RenderProjectileModel;
import com.lycanitesmobs.core.renderer.RenderProjectileSprite;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderFactoryProjectile<T extends EntityProjectileBase>
implements IRenderFactory {
    protected String oldProjectileName;
    protected Class oldProjectileClass;
    protected boolean oldModel;

    public RenderFactoryProjectile() {
    }

    public RenderFactoryProjectile(String projectileName, Class projectileClass, boolean hasModel) {
        this.oldProjectileName = projectileName;
        this.oldProjectileClass = projectileClass;
        this.oldModel = hasModel;
    }

    public EntityRenderer<? super T> createRenderFor(EntityRendererManager manager) {
        if (this.oldModel) {
            try {
                return new RenderProjectileModel(this.oldProjectileName, manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.oldProjectileClass != null) {
            return new RenderProjectileSprite(manager, this.oldProjectileClass);
        }
        return new RenderProjectileSprite(manager, EntityProjectileCustom.class);
    }
}

