/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.renderer;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.model.ModelCreatureBase;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderCreature
extends LivingRenderer<EntityCreatureBase, ModelCreatureBase> {
    public boolean multipass = true;
    protected ModelCreatureBase defaultModel = (ModelCreatureBase)this.field_77045_g;

    public RenderCreature(String entityID, EntityRendererManager renderManager, float shadowSize) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        super(renderManager, (EntityModel)AssetManager.getCreatureModel(CreatureManager.getInstance().getCreature(entityID)), shadowSize);
        ModelCreatureBase modelCreatureBase = (ModelCreatureBase)this.field_77045_g;
        if (modelCreatureBase == null) {
            return;
        }
        modelCreatureBase.addCustomLayers(this);
    }

    public boolean func_188295_H_() {
        return false;
    }

    public void doRender(EntityCreatureBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        try {
            this.field_77045_g = AssetManager.getCreatureModel(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.field_77045_g = this.defaultModel;
        if (this.field_77045_g == null) {
            return;
        }
        super.func_76986_a((LivingEntity)entity, x, y, z, entityYaw, partialTicks);
    }

    public void renderMultipass(EntityCreatureBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
    }

    protected void renderModel(EntityCreatureBase entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        super.func_77036_a((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
    }

    protected void renderLayers(EntityCreatureBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        super.func_177093_a((LivingEntity)entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scaleFactor);
    }

    public ModelCreatureBase getMainModel() {
        return (ModelCreatureBase)this.field_77045_g;
    }

    protected boolean bindEntityTexture(EntityCreatureBase entity) {
        ResourceLocation texture = this.getEntityTexture(entity);
        if (texture == null) {
            return false;
        }
        this.func_110776_a(texture);
        return true;
    }

    protected ResourceLocation getEntityTexture(EntityCreatureBase entity) {
        return entity.getTexture();
    }

    protected void bindEquipmentTexture(EntityCreatureBase entity, String equipmentName) {
        this.func_110776_a(this.getEquipmentTexture(entity, equipmentName));
    }

    protected ResourceLocation getEquipmentTexture(EntityCreatureBase entity, String equipmentName) {
        if (entity != null) {
            return entity.getEquipmentTexture(equipmentName);
        }
        return null;
    }

    protected void preRenderCallback(EntityCreatureBase entity, float particleTickTime) {
    }

    protected boolean canRenderName(EntityCreatureBase entity) {
        if (!Minecraft.func_71382_s()) {
            return false;
        }
        if (entity.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            return false;
        }
        if (entity.func_184179_bs() != null) {
            return false;
        }
        if (entity.func_94059_bO()) {
            if (entity.isTamed()) {
                return entity == this.field_76990_c.field_147941_i;
            }
            return true;
        }
        return entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i;
    }

    public float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }
}

