/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.pets;

import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.Subspecies;
import net.minecraft.nbt.CompoundNBT;

public class SummonSet {
    public ExtendedPlayer playerExt;
    public String summonType = "";
    public int subspecies = 0;
    public boolean summonableOnly = true;
    public boolean sitting = false;
    public boolean following = true;
    public boolean passive = false;
    public boolean assist = true;
    public boolean aggressive = false;
    public boolean pvp = false;

    public static boolean isSummonableCreature(String creatureName) {
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(creatureName);
        if (creatureInfo == null) {
            return false;
        }
        if (creatureInfo.dummy) {
            return false;
        }
        return creatureInfo.isSummonable();
    }

    public SummonSet(ExtendedPlayer playerExt) {
        this.playerExt = playerExt;
    }

    public void setSummonType(String summonType) {
        this.summonType = summonType != null ? summonType.toLowerCase() : null;
    }

    public void setSubspecies(int subspecies) {
        this.subspecies = subspecies;
    }

    public int getSubspecies() {
        return this.subspecies;
    }

    public boolean getSitting() {
        return this.sitting;
    }

    public boolean getFollowing() {
        return this.following;
    }

    public boolean getPassive() {
        return this.passive;
    }

    public boolean getAssist() {
        return this.assist;
    }

    public boolean getAggressive() {
        return this.aggressive;
    }

    public boolean getPVP() {
        return this.pvp;
    }

    public CreatureInfo getCreatureInfo() {
        return CreatureManager.getInstance().getCreature(this.summonType.toLowerCase());
    }

    public void applyBehaviour(EntityCreatureTameable minion) {
        minion.setSitting(this.getSitting());
        minion.setFollowing(this.getFollowing());
        minion.setPassive(this.getPassive());
        minion.setAssist(this.getAssist());
        minion.setAggressive(this.getAggressive());
        minion.setPVP(this.getPVP());
    }

    public void updateBehaviour(EntityCreatureTameable minion) {
        this.sitting = minion.isSitting();
        this.following = minion.isFollowing();
        this.passive = minion.isPassive();
        this.assist = minion.isAssisting();
        this.aggressive = minion.func_213398_dR();
        this.pvp = minion.isPVP();
    }

    public boolean isUseable() {
        if (this.summonType == null || "".equals(this.summonType) || CreatureManager.getInstance().getCreature(this.summonType) == null || !SummonSet.isSummonableCreature(this.summonType)) {
            return false;
        }
        if (this.playerExt != null) {
            CreatureInfo creatureInfo = this.getCreatureInfo();
            CreatureKnowledge creatureKnowledge = this.playerExt.getBeastiary().getCreatureKnowledge(creatureInfo.getName());
            if (creatureKnowledge == null) {
                return false;
            }
            Subspecies subspecies = creatureInfo.getSubspecies(this.subspecies);
            if (subspecies == null) {
                return true;
            }
            if (subspecies.skin != null) {
                return this.playerExt.getBeastiary().hasKnowledgeRank(creatureInfo.getName(), 3);
            }
            return this.playerExt.getBeastiary().hasKnowledgeRank(creatureInfo.getName(), 2);
        }
        return true;
    }

    public Class getCreatureClass() {
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(this.summonType);
        if (creatureInfo == null) {
            return null;
        }
        return creatureInfo.entityClass;
    }

    public void readFromPacket(String summonType, int subspecies, byte behaviour) {
        this.setSummonType(summonType);
        this.setSubspecies(subspecies);
        this.setBehaviourByte(behaviour);
    }

    public void setBehaviourByte(byte behaviour) {
        this.sitting = (behaviour & BEHAVIOUR_ID.SITTING.id) > 0;
        this.following = (behaviour & BEHAVIOUR_ID.FOLLOWING.id) > 0;
        this.passive = (behaviour & BEHAVIOUR_ID.PASSIVE.id) > 0;
        this.assist = (behaviour & BEHAVIOUR_ID.ASSIST.id) > 0;
        this.aggressive = (behaviour & BEHAVIOUR_ID.AGGRESSIVE.id) > 0;
        this.pvp = (behaviour & BEHAVIOUR_ID.PVP.id) > 0;
    }

    public byte getBehaviourByte() {
        byte behaviour = 0;
        if (this.getSitting()) {
            behaviour = (byte)(behaviour + BEHAVIOUR_ID.SITTING.id);
        }
        if (this.getFollowing()) {
            behaviour = (byte)(behaviour + BEHAVIOUR_ID.FOLLOWING.id);
        }
        if (this.getPassive()) {
            behaviour = (byte)(behaviour + BEHAVIOUR_ID.PASSIVE.id);
        }
        if (this.getAggressive()) {
            behaviour = (byte)(behaviour + BEHAVIOUR_ID.AGGRESSIVE.id);
        }
        if (this.getPVP()) {
            behaviour = (byte)(behaviour + BEHAVIOUR_ID.PVP.id);
        }
        return behaviour;
    }

    public void read(CompoundNBT nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("SummonType")) {
            this.setSummonType(nbtTagCompound.func_74779_i("SummonType"));
        }
        if (nbtTagCompound.func_74764_b("Subspecies")) {
            this.setSubspecies(nbtTagCompound.func_74762_e("Subspecies"));
        }
        if (nbtTagCompound.func_74764_b("Sitting")) {
            this.sitting = nbtTagCompound.func_74767_n("Sitting");
        }
        if (nbtTagCompound.func_74764_b("Following")) {
            this.following = nbtTagCompound.func_74767_n("Following");
        }
        if (nbtTagCompound.func_74764_b("Passive")) {
            this.passive = nbtTagCompound.func_74767_n("Passive");
        }
        if (nbtTagCompound.func_74764_b("Aggressive")) {
            this.aggressive = nbtTagCompound.func_74767_n("Aggressive");
        }
        if (nbtTagCompound.func_74764_b("PVP")) {
            this.pvp = nbtTagCompound.func_74767_n("PVP");
        }
    }

    public void write(CompoundNBT nbtTagCompound) {
        nbtTagCompound.func_74778_a("SummonType", this.summonType);
        nbtTagCompound.func_74768_a("Subspecies", this.getSubspecies());
        nbtTagCompound.func_74757_a("Sitting", this.sitting);
        nbtTagCompound.func_74757_a("Following", this.following);
        nbtTagCompound.func_74757_a("Passive", this.passive);
        nbtTagCompound.func_74757_a("Aggressive", this.aggressive);
        nbtTagCompound.func_74757_a("PVP", this.pvp);
    }

    public static enum BEHAVIOUR_ID {
        SITTING(1),
        FOLLOWING(2),
        PASSIVE(4),
        ASSIST(8),
        AGGRESSIVE(16),
        PVP(32);

        public byte id;

        private BEHAVIOUR_ID(byte i) {
            this.id = i;
        }
    }
}

