/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.core.network.MessageBeastiary;
import com.lycanitesmobs.core.network.MessageCreatureKnowledge;
import com.lycanitesmobs.core.network.MessageEntityGUICommand;
import com.lycanitesmobs.core.network.MessageEntityPickedUp;
import com.lycanitesmobs.core.network.MessageEntityVelocity;
import com.lycanitesmobs.core.network.MessageGUIRequest;
import com.lycanitesmobs.core.network.MessageMobEvent;
import com.lycanitesmobs.core.network.MessagePetEntry;
import com.lycanitesmobs.core.network.MessagePetEntryRemove;
import com.lycanitesmobs.core.network.MessagePlayerAttack;
import com.lycanitesmobs.core.network.MessagePlayerControl;
import com.lycanitesmobs.core.network.MessagePlayerStats;
import com.lycanitesmobs.core.network.MessageSummonSet;
import com.lycanitesmobs.core.network.MessageSummonSetSelection;
import com.lycanitesmobs.core.network.MessageSummoningPedestalStats;
import com.lycanitesmobs.core.network.MessageSummoningPedestalSummonSet;
import com.lycanitesmobs.core.network.MessageTileEntityButton;
import com.lycanitesmobs.core.network.MessageWorldEvent;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("lycanitesmobs", "main_channel")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();

    public void register() {
        int messageID = 0;
        HANDLER.registerMessage(messageID++, MessageBeastiary.class, MessageBeastiary::encode, MessageBeastiary::decode, MessageBeastiary::handle);
        HANDLER.registerMessage(messageID++, MessageCreatureKnowledge.class, MessageCreatureKnowledge::encode, MessageCreatureKnowledge::decode, MessageCreatureKnowledge::handle);
        HANDLER.registerMessage(messageID++, MessagePlayerStats.class, MessagePlayerStats::encode, MessagePlayerStats::decode, MessagePlayerStats::handle);
        HANDLER.registerMessage(messageID++, MessagePetEntry.class, MessagePetEntry::encode, MessagePetEntry::decode, MessagePetEntry::handle);
        HANDLER.registerMessage(messageID++, MessagePetEntryRemove.class, MessagePetEntryRemove::encode, MessagePetEntryRemove::decode, MessagePetEntryRemove::handle);
        HANDLER.registerMessage(messageID++, MessageSummonSet.class, MessageSummonSet::encode, MessageSummonSet::decode, MessageSummonSet::handle);
        HANDLER.registerMessage(messageID++, MessageSummonSetSelection.class, MessageSummonSetSelection::encode, MessageSummonSetSelection::decode, MessageSummonSetSelection::handle);
        HANDLER.registerMessage(messageID++, MessageEntityPickedUp.class, MessageEntityPickedUp::encode, MessageEntityPickedUp::decode, MessageEntityPickedUp::handle);
        HANDLER.registerMessage(messageID++, MessageWorldEvent.class, MessageWorldEvent::encode, MessageWorldEvent::decode, MessageWorldEvent::handle);
        HANDLER.registerMessage(messageID++, MessageMobEvent.class, MessageMobEvent::encode, MessageMobEvent::decode, MessageMobEvent::handle);
        HANDLER.registerMessage(messageID++, MessageSummoningPedestalStats.class, MessageSummoningPedestalStats::encode, MessageSummoningPedestalStats::decode, MessageSummoningPedestalStats::handle);
        HANDLER.registerMessage(messageID++, MessageEntityVelocity.class, MessageEntityVelocity::encode, MessageEntityVelocity::decode, MessageEntityVelocity::handle);
        HANDLER.registerMessage(messageID++, MessageEntityGUICommand.class, MessageEntityGUICommand::encode, MessageEntityGUICommand::decode, MessageEntityGUICommand::handle);
        HANDLER.registerMessage(messageID++, MessageGUIRequest.class, MessageGUIRequest::encode, MessageGUIRequest::decode, MessageGUIRequest::handle);
        HANDLER.registerMessage(messageID++, MessagePlayerControl.class, MessagePlayerControl::encode, MessagePlayerControl::decode, MessagePlayerControl::handle);
        HANDLER.registerMessage(messageID++, MessagePlayerAttack.class, MessagePlayerAttack::encode, MessagePlayerAttack::decode, MessagePlayerAttack::handle);
        HANDLER.registerMessage(messageID++, MessageSummoningPedestalSummonSet.class, MessageSummoningPedestalSummonSet::encode, MessageSummoningPedestalSummonSet::decode, MessageSummoningPedestalSummonSet::handle);
        HANDLER.registerMessage(messageID++, MessageTileEntityButton.class, MessageTileEntityButton::encode, MessageTileEntityButton::decode, MessageTileEntityButton::handle);
    }

    public <MSG> void sendToPlayer(MSG message, ServerPlayerEntity player) {
        HANDLER.sendTo(message, player.field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public <MSG> void sendToAllAround(MSG message, World world, Vec3d pos, double range) {
        for (PlayerEntity player : world.func_217369_A()) {
            if (!(player instanceof ServerPlayerEntity) || !(player.func_195048_a(pos) <= range)) continue;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            HANDLER.sendTo(message, serverPlayer.field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public <MSG> void sendToWorld(MSG message, World world) {
        for (PlayerEntity player : world.func_217369_A()) {
            if (!(player instanceof ServerPlayerEntity)) continue;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            HANDLER.sendTo(message, serverPlayer.field_71135_a.func_147362_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public <MSG> void sendToServer(MSG message) {
        HANDLER.sendToServer(message);
    }
}

