/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.core.tileentity.TileEntityBase;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageTileEntityButton {
    public byte buttonId;
    public BlockPos tileEntityPos;

    public MessageTileEntityButton() {
    }

    public MessageTileEntityButton(byte buttonId, BlockPos tileEntityPos) {
        this.buttonId = buttonId;
        this.tileEntityPos = tileEntityPos;
    }

    public static void handle(MessageTileEntityButton message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            TileEntity tileEntity = player.func_130014_f_().func_175625_s(message.tileEntityPos);
            if (!(tileEntity instanceof TileEntityBase)) {
                return;
            }
            TileEntityBase tileEntityBase = (TileEntityBase)tileEntity;
            tileEntityBase.onGuiButton(message.buttonId);
        });
    }

    public static MessageTileEntityButton decode(PacketBuffer packet) {
        MessageTileEntityButton message = new MessageTileEntityButton();
        message.buttonId = packet.readByte();
        message.tileEntityPos = new BlockPos(packet.readInt(), packet.readInt(), packet.readInt());
        return message;
    }

    public static void encode(MessageTileEntityButton message, PacketBuffer packet) {
        packet.writeByte((int)message.buttonId);
        packet.writeInt(message.tileEntityPos.func_177958_n());
        packet.writeInt(message.tileEntityPos.func_177956_o());
        packet.writeInt(message.tileEntityPos.func_177952_p());
    }
}

