/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.core.pets.SummonSet;
import com.lycanitesmobs.core.tileentity.TileEntitySummoningPedestal;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSummoningPedestalSummonSet {
    public String summonType;
    public int subpsecies;
    public byte behaviour;
    public int x;
    public int y;
    public int z;

    public MessageSummoningPedestalSummonSet() {
    }

    public MessageSummoningPedestalSummonSet(SummonSet summonSet, int x, int y, int z) {
        this.summonType = summonSet.summonType;
        this.subpsecies = summonSet.subspecies;
        this.behaviour = summonSet.getBehaviourByte();
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void handle(MessageSummoningPedestalSummonSet message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            TileEntity tileEntity = player.func_130014_f_().func_175625_s(new BlockPos(message.x, message.y, message.z));
            TileEntitySummoningPedestal summoningPedestal = null;
            if (tileEntity instanceof TileEntitySummoningPedestal) {
                summoningPedestal = (TileEntitySummoningPedestal)tileEntity;
            }
            if (summoningPedestal == null) {
                return;
            }
            if (summoningPedestal.summonSet == null) {
                summoningPedestal.summonSet = new SummonSet(null);
            }
            summoningPedestal.summonSet.readFromPacket(message.summonType, message.subpsecies, message.behaviour);
        });
    }

    public static MessageSummoningPedestalSummonSet decode(PacketBuffer packet) {
        MessageSummoningPedestalSummonSet message = new MessageSummoningPedestalSummonSet();
        message.x = packet.readInt();
        message.y = packet.readInt();
        message.z = packet.readInt();
        message.summonType = packet.func_150789_c(256);
        message.subpsecies = packet.readInt();
        message.behaviour = packet.readByte();
        return message;
    }

    public static void encode(MessageSummoningPedestalSummonSet message, PacketBuffer packet) {
        packet.writeInt(message.x);
        packet.writeInt(message.y);
        packet.writeInt(message.z);
        packet.func_180714_a(message.summonType);
        packet.writeInt(message.subpsecies);
        packet.writeByte((int)message.behaviour);
    }
}

