/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.ExtendedPlayer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSummonSetSelection {
    public byte summonSetID;

    public MessageSummonSetSelection() {
    }

    public MessageSummonSetSelection(ExtendedPlayer playerExt) {
        this.summonSetID = (byte)playerExt.selectedSummonSet;
    }

    public static void handle(MessageSummonSetSelection message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.LOGIN_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer((PlayerEntity)player);
                playerExt.setSelectedSummonSet(message.summonSetID);
            });
            return;
        }
        PlayerEntity player = ClientManager.getInstance().getClientPlayer();
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return;
        }
        playerExt.setSelectedSummonSet(message.summonSetID);
    }

    public static MessageSummonSetSelection decode(PacketBuffer packet) {
        MessageSummonSetSelection message = new MessageSummonSetSelection();
        message.summonSetID = packet.readByte();
        return message;
    }

    public static void encode(MessageSummonSetSelection message, PacketBuffer packet) {
        packet.writeByte((int)message.summonSetID);
    }
}

