/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.pets.PetEntry;
import com.lycanitesmobs.core.pets.PetManager;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessagePetEntryRemove {
    public int petEntryID;

    public MessagePetEntryRemove() {
    }

    public MessagePetEntryRemove(ExtendedPlayer playerExt, PetEntry petEntry) {
        this.petEntryID = petEntry.petEntryID;
    }

    public static void handle(MessagePetEntryRemove message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.LOGIN_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer((PlayerEntity)player);
                PetManager petManager = playerExt.petManager;
                PetEntry petEntry = petManager.getEntry(message.petEntryID);
                if (petEntry == null) {
                    LycanitesMobs.logWarning("", "Tried to remove a null PetEntry from server!");
                    return;
                }
                petEntry.remove();
            });
            return;
        }
        PlayerEntity player = ClientManager.getInstance().getClientPlayer();
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return;
        }
        PetManager petManager = playerExt.petManager;
        PetEntry petEntry = petManager.getEntry(message.petEntryID);
        if (petEntry == null) {
            LycanitesMobs.logWarning("", "Tried to remove a null PetEntry from client!");
            return;
        }
        petEntry.remove();
    }

    public static MessagePetEntryRemove decode(PacketBuffer packet) {
        MessagePetEntryRemove message = new MessagePetEntryRemove();
        try {
            message.petEntryID = packet.readInt();
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "There was a problem decoding the packet: " + packet + ".");
            e.printStackTrace();
        }
        return message;
    }

    public static void encode(MessagePetEntryRemove message, PacketBuffer packet) {
        try {
            packet.writeInt(message.petEntryID);
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "There was a problem encoding the packet: " + packet + ".");
            e.printStackTrace();
        }
    }
}

