/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.ClientManager;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageEntityVelocity {
    public int entityID;
    public int motionX;
    public int motionY;
    public int motionZ;

    public MessageEntityVelocity() {
    }

    public MessageEntityVelocity(Entity entity, double motionX, double motionY, double motionZ) {
        this.entityID = entity.func_145782_y();
        if (motionX < -3.9) {
            motionX = -3.9;
        }
        if (motionY < -3.9) {
            motionY = -3.9;
        }
        if (motionZ < -3.9) {
            motionZ = -3.9;
        }
        if (motionX > 3.9) {
            motionX = 3.9;
        }
        if (motionY > 3.9) {
            motionY = 3.9;
        }
        if (motionZ > 3.9) {
            motionZ = 3.9;
        }
        this.motionX = (int)(motionX * 8000.0);
        this.motionY = (int)(motionY * 8000.0);
        this.motionZ = (int)(motionZ * 8000.0);
    }

    public static void handle(MessageEntityVelocity message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() != NetworkDirection.LOGIN_TO_CLIENT) {
            return;
        }
        PlayerEntity player = ClientManager.getInstance().getClientPlayer();
        World world = player.func_130014_f_();
        Entity entity = world.func_73045_a(message.entityID);
        entity.func_213317_d(entity.func_213322_ci().func_72441_c((double)message.motionX / 8000.0, (double)message.motionY / 8000.0, (double)message.motionZ / 8000.0));
    }

    public static MessageEntityVelocity decode(PacketBuffer packet) {
        MessageEntityVelocity message = new MessageEntityVelocity();
        message.entityID = packet.func_150792_a();
        message.motionX = packet.readShort();
        message.motionY = packet.readShort();
        message.motionZ = packet.readShort();
        return message;
    }

    public static void encode(MessageEntityVelocity message, PacketBuffer packet) {
        packet.func_150787_b(message.entityID);
        packet.writeShort(message.motionX);
        packet.writeShort(message.motionY);
        packet.writeShort(message.motionZ);
    }
}

