/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.ExtendedEntity;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageEntityPickedUp {
    public int pickedUpEntityID;
    public int pickedUpByEntityID;

    public MessageEntityPickedUp() {
    }

    public MessageEntityPickedUp(Entity pickedUpEntity, Entity pickedUpByEntity) {
        this.pickedUpEntityID = pickedUpEntity.func_145782_y();
        this.pickedUpByEntityID = pickedUpByEntity != null ? pickedUpByEntity.func_145782_y() : 0;
    }

    public static void handle(MessageEntityPickedUp message, Supplier<NetworkEvent.Context> ctx) {
        Entity pickedUpByEntity;
        if (ctx.get().getDirection() != NetworkDirection.LOGIN_TO_CLIENT) {
            return;
        }
        PlayerEntity player = ClientManager.getInstance().getClientPlayer();
        World world = player.func_130014_f_();
        Entity pickedUpEntity = world.func_73045_a(message.pickedUpEntityID);
        Entity entity = pickedUpByEntity = message.pickedUpByEntityID != 0 ? world.func_73045_a(message.pickedUpByEntityID) : null;
        if (!(pickedUpEntity instanceof LivingEntity)) {
            return;
        }
        ExtendedEntity pickedUpEntityExt = ExtendedEntity.getForEntity((LivingEntity)pickedUpEntity);
        if (pickedUpEntityExt != null) {
            pickedUpEntityExt.setPickedUpByEntity(pickedUpByEntity);
        }
    }

    public static MessageEntityPickedUp decode(PacketBuffer packet) {
        MessageEntityPickedUp message = new MessageEntityPickedUp();
        message.pickedUpEntityID = packet.readInt();
        message.pickedUpByEntityID = packet.readInt();
        return message;
    }

    public static void encode(MessageEntityPickedUp message, PacketBuffer packet) {
        packet.writeInt(message.pickedUpEntityID);
        packet.writeInt(message.pickedUpByEntityID);
    }
}

