/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageEntityGUICommand {
    int entityID;
    public byte guiCommandID;

    public MessageEntityGUICommand() {
    }

    public MessageEntityGUICommand(byte guiCommandID, Entity entity) {
        this.entityID = entity.func_145782_y();
        this.guiCommandID = guiCommandID;
    }

    public static void handle(MessageEntityGUICommand message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.func_130014_f_();
            Entity entity = world.func_73045_a(message.entityID);
            if (entity instanceof EntityCreatureTameable) {
                EntityCreatureTameable pet = (EntityCreatureTameable)entity;
                pet.performGUICommand((PlayerEntity)player, message.guiCommandID);
            }
        });
    }

    public static MessageEntityGUICommand decode(PacketBuffer packet) {
        MessageEntityGUICommand message = new MessageEntityGUICommand();
        message.entityID = packet.readInt();
        message.guiCommandID = packet.readByte();
        return message;
    }

    public static void encode(MessageEntityGUICommand message, PacketBuffer packet) {
        packet.writeInt(message.entityID);
        packet.writeByte((int)message.guiCommandID);
    }
}

