/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.mods;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import java.lang.reflect.Method;
import net.minecraftforge.fml.ModList;

public class DLDungeons {
    public static void init() {
        if (!ModList.get().isLoaded("DLDungeonsJBG") && !ModList.get().isLoaded("dldungeonsjbg")) {
            return;
        }
        LycanitesMobs.logInfo("", "Doomlike Dungeons Mod Detected...");
        Class<?> dlDungeonsAPI = null;
        Method isLoaded = null;
        try {
            dlDungeonsAPI = Class.forName("jaredbgreat.dldungeons.api.DLDungeonsAPI");
            isLoaded = dlDungeonsAPI.getMethod("isLoaded", new Class[0]);
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "Unable to find DLDungeons API Class/Method via reflection:");
            e.printStackTrace();
        }
        if (dlDungeonsAPI == null || isLoaded == null) {
            return;
        }
        try {
            if (((Boolean)isLoaded.invoke(null, new Object[0])).booleanValue()) {
                CreatureManager.getInstance().dlDungeonsLoaded = true;
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "Unable to invoke DLDungeons API method isLoaded():");
            e.printStackTrace();
        }
    }

    public static void addMob(CreatureInfo creatureInfo) {
        String mobName = creatureInfo.getEntityId();
        String themes = "";
        boolean first = true;
        for (String biomeTag : creatureInfo.creatureSpawn.biomeTags) {
            if (!first) {
                themes = themes + ",";
            }
            first = false;
            if (biomeTag.charAt(0) == '-' || biomeTag.charAt(0) == '+') {
                biomeTag = biomeTag.substring(1);
            }
            if ("DRY".equalsIgnoreCase(biomeTag)) {
                biomeTag = "DESERT";
            } else if ("COLD".equalsIgnoreCase(biomeTag)) {
                biomeTag = "FROZEN";
            } else if ("VOID".equalsIgnoreCase(biomeTag)) {
                biomeTag = "SHADOW";
            } else if ("SPOOKY".equalsIgnoreCase(biomeTag)) {
                biomeTag = "NECRO";
            }
            themes = themes + biomeTag;
        }
        if (!"".equalsIgnoreCase(themes) && creatureInfo.dungeonLevel > 0) {
            try {
                Class<?> dlDungeonsAPI = Class.forName("jaredbgreat.dldungeons.api.DLDungeonsAPI");
                Method addMob = dlDungeonsAPI.getMethod("addMob", String.class, Integer.TYPE, String[].class);
                addMob.invoke(null, mobName, creatureInfo.dungeonLevel, themes.split(","));
                LycanitesMobs.logDebug("MobSetup", "[DLDungeons] Added " + mobName + " with the level: " + creatureInfo.dungeonLevel + " and themes: " + themes);
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "Unable to add " + mobName + " to DLDungeons API:");
            }
        }
    }
}

