/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model.projectile;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.model.ModelProjectileObj;
import com.lycanitesmobs.core.renderer.RenderProjectileModel;
import com.lycanitesmobs.core.renderer.layer.LayerProjectileBase;
import com.lycanitesmobs.core.renderer.layer.LayerProjectileEffect;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.vecmath.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelLightBall
extends ModelProjectileObj {
    LayerProjectileBase ballGlowLayer;

    public ModelLightBall() {
        this(1.0f);
    }

    public ModelLightBall(float shadowSize) {
        this.initModel("lightball", LycanitesMobs.modInfo, "projectile/lightball");
    }

    @Override
    public void addCustomLayers(RenderProjectileModel renderer) {
        super.addCustomLayers(renderer);
        this.ballGlowLayer = new LayerProjectileEffect(renderer, "", true, LayerProjectileEffect.BLEND.ADD.id, true);
        renderer.addLayer(this.ballGlowLayer);
    }

    @Override
    public void animatePart(String partName, EntityProjectileBase entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        this.rotate(loop * 8.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean canRenderPart(String partName, EntityProjectileBase entity, LayerProjectileBase layer, boolean trophy) {
        if (partName.equals("ball02") || partName.equals("ball03")) {
            return layer == this.ballGlowLayer;
        }
        return layer == null;
    }

    @Override
    public Vector4f getPartColor(String partName, EntityProjectileBase entity, LayerProjectileBase layer, boolean trophy, float loop) {
        float glowSpeed = 40.0f;
        float glow = loop * glowSpeed % 360.0f;
        float color = (float)Math.cos(Math.toRadians(glow)) * 0.1f + 0.9f;
        return new Vector4f(color, color, color, 1.0f);
    }

    @Override
    public void onRenderStart(LayerProjectileBase layer, EntityProjectileBase entity) {
        super.onRenderStart(layer, entity);
        int i = 0xF000F0;
        int j = i % 65536;
        int k = i / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
        GlStateManager.disableLighting();
    }

    @Override
    public void onRenderFinish(LayerProjectileBase layer, EntityProjectileBase entity) {
        super.onRenderFinish(layer, entity);
        int i = entity.func_70070_b();
        int j = i % 65536;
        int k = i / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
        GlStateManager.enableLighting();
    }
}

