/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.model.template.ModelTemplateElemental;
import com.lycanitesmobs.core.renderer.RenderCreature;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureEffect;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureScrolling;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelXaphan
extends ModelTemplateElemental {
    float maxLeg = 0.0f;

    public ModelXaphan() {
        this(1.0f);
    }

    public ModelXaphan(float shadowSize) {
        this.initModel("xaphan", LycanitesMobs.modInfo, "entity/xaphan");
        this.trophyScale = 0.8f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureScrolling(renderer, "ball", true, LayerCreatureEffect.BLEND.NORMAL.id, true, new Vector2f(0.0f, 4.0f)));
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "ring", true, LayerCreatureEffect.BLEND.ADD.id, true));
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (partName.equals("fingerleft01") || partName.equals("fingerright01")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.2f)) * 0.2f - 0.2f), 0.0f, 0.0f);
        } else if (partName.equals("fingerleft02") || partName.equals("fingerright02")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)((loop + 20.0f) * 0.2f)) * 0.2f - 0.2f), 0.0f, 0.0f);
        } else if (partName.equals("fingerleft03") || partName.equals("fingerright03")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)((loop + 40.0f) * 0.2f)) * 0.2f - 0.2f), 0.0f, 0.0f);
        } else if (partName.equals("shoulderleft")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f), 0.0f, (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.1f));
        } else if (partName.equals("shoulderright")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f), 0.0f, (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.1f)));
        } else if (partName.equals("effect01")) {
            this.rotate(0.0f, loop * 16.0f, 0.0f);
        } else if (partName.contains("ball")) {
            this.shiftOrigin(partName, "body");
            this.rotate(0.0f, loop * -8.0f, 0.0f);
            this.shiftOriginBack(partName, "body");
            float ballScale = (float)(1.0 + 0.2 * (double)MathHelper.func_76134_b((float)loop));
            if (partName.equals("ball02")) {
                ballScale = (float)(1.0 + 0.2 * (double)MathHelper.func_76134_b((float)(loop + 20.0f)));
            } else if (partName.equals("ball03")) {
                ballScale = (float)(1.0 + 0.2 * (double)MathHelper.func_76134_b((float)(loop + 40.0f)));
            } else if (partName.equals("ball04")) {
                ballScale = (float)(1.0 + 0.2 * (double)MathHelper.func_76134_b((float)(loop + 60.0f)));
            }
            this.scale(ballScale, ballScale, ballScale);
        } else if (partName.contains("spine")) {
            float coil = 8.0f;
            this.rotate(MathHelper.func_76134_b((float)(loop * 0.1f)) * coil - coil * 90.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if ("effect01".equals(partName)) {
            return layer != null && "ring".equals(layer.name);
        }
        if (partName.contains("ball")) {
            return layer != null && "ball".equals(layer.name);
        }
        return layer == null;
    }

    @Override
    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        return super.getPartColor(partName, entity, layer, trophy, loop);
    }
}

