/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.model.ModelCreatureObjOld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelWendigo
extends ModelCreatureObjOld {
    float maxLeg = 0.0f;

    public ModelWendigo() {
        this(1.0f);
    }

    public ModelWendigo(float shadowSize) {
        this.initModel("Wendigo", LycanitesMobs.modInfo, "entity/wendigo");
        this.setPartCenter("head", 0.0f, 4.392f, -0.216f);
        this.setPartCenter("mouth", 0.0f, 4.4568f, -1.1376f);
        this.setPartCenter("body", 0.0f, 3.908f, 0.3f);
        this.setPartCenter("armleft", 0.504f, 4.032f, -0.036f);
        this.setPartCenter("armright", -0.504f, 4.032f, -0.036f);
        this.setPartCenter("legleft", 0.216f, 2.592f, 0.0f);
        this.setPartCenter("legright", -0.216f, 2.592f, 0.0f);
        this.lockHeadY = true;
        this.trophyScale = 0.8f;
        this.trophyOffset = new float[]{0.0f, -0.2f, 0.0f};
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("mouth")) {
            this.centerPartToPart("mouth", "head");
            if (!this.lockHeadX) {
                this.rotate((float)Math.toDegrees(lookX / 57.295776f), 0.0f, 0.0f);
            }
            if (!this.lockHeadY) {
                this.rotate(0.0f, (float)Math.toDegrees(lookY / 57.295776f), 0.0f);
            }
            this.uncenterPartToPart("mouth", "head");
        }
        if (partName.equals("mouth")) {
            rotX += MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f;
        }
        if (partName.equals("armleft")) {
            rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX - Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (partName.equals("armright")) {
            rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (entity == null || entity.field_70122_E || entity.func_70090_H()) {
            float walkSwing = 0.6f;
            if (partName.equals("armleft")) {
                rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 1.0f * distance * 0.5f));
                rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 0.5f * distance * 0.5f));
            }
            if (partName.equals("armright")) {
                rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 1.0f * distance * 0.5f));
                rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 0.5f * distance * 0.5f));
            }
            if (partName.equals("legleft")) {
                rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 1.4f * distance));
            }
            if (partName.equals("legright")) {
                rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 1.4f * distance));
            }
        }
        if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).isAttackOnCooldown()) {
            if (partName.equals("armleft") || partName.equals("armright")) {
                rotX -= 65.0f;
            }
            if (partName.equals("armleft")) {
                rotY -= 20.0f;
            }
            if (partName.equals("armright")) {
                rotY += 20.0f;
            }
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }
}

