/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.model.template.ModelTemplateElemental;
import com.lycanitesmobs.core.renderer.RenderCreature;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureEffect;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelVapula
extends ModelTemplateElemental {
    float maxLeg = 0.0f;

    public ModelVapula() {
        this(1.0f);
    }

    public ModelVapula(float shadowSize) {
        this.initModel("vapula", LycanitesMobs.modInfo, "entity/vapula");
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "", true, LayerCreatureEffect.BLEND.NORMAL.id, true));
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (partName.contains("effect")) {
            this.shiftOrigin(partName, "crystals");
            this.rotate(0.0f, 0.0f, loop * 8.0f);
            this.shiftOriginBack(partName, "crystals");
        } else if (partName.equals("fingerleft01") || partName.equals("fingerright01")) {
            this.rotate(0.0f, (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.2f)) * 0.2f - 0.2f), 0.0f);
        } else if (partName.equals("fingerleft02") || partName.equals("fingerright02")) {
            this.rotate(0.0f, (float)Math.toDegrees(MathHelper.func_76134_b((float)((loop + 20.0f) * 0.2f)) * 0.2f - 0.2f), 0.0f);
        } else if (partName.equals("fingerleft03") || partName.equals("fingerright03")) {
            this.rotate(0.0f, (float)Math.toDegrees(MathHelper.func_76134_b((float)((loop + 40.0f) * 0.2f)) * 0.2f - 0.2f), 0.0f);
        }
    }

    @Override
    public boolean canBaseRenderPart(String partName, Entity entity, boolean trophy) {
        return true;
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (!this.isCrystal(partName)) {
            return layer == null;
        }
        if (layer instanceof LayerCreatureEffect) {
            if (partName.contains("effect")) {
                if (entity instanceof EntityCreatureBase) {
                    byte attackPhase = ((EntityCreatureBase)entity).getAttackPhase();
                    if (((EntityCreatureBase)entity).isAttackOnCooldown() && attackPhase == 0) {
                        return false;
                    }
                    if ("effect01".equals(partName)) {
                        return attackPhase <= 7;
                    }
                    if ("effect02".equals(partName)) {
                        return attackPhase <= 6;
                    }
                    if ("effect03".equals(partName)) {
                        return attackPhase <= 5;
                    }
                    if ("effect04".equals(partName)) {
                        return attackPhase <= 4;
                    }
                    if ("effect05".equals(partName)) {
                        return attackPhase <= 3;
                    }
                    if ("effect06".equals(partName)) {
                        return attackPhase <= 2;
                    }
                    if ("effect07".equals(partName)) {
                        return attackPhase <= 1;
                    }
                    if ("effect08".equals(partName)) {
                        return attackPhase <= 0;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean isCrystal(String partName) {
        if ("eye".equals(partName) || "crystals".equals(partName)) {
            return true;
        }
        return partName.contains("effect") || partName.contains("finger");
    }

    @Override
    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (this.isCrystal(partName)) {
            float glowSpeed = 40.0f;
            float glow = loop * glowSpeed % 360.0f;
            float color = (float)Math.cos(Math.toRadians(glow)) * 0.1f + 0.9f;
            return new Vector4f(color, color, color, 1.0f);
        }
        return super.getPartColor(partName, entity, layer, trophy, loop);
    }
}

