/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.model.template.ModelTemplateBiped;
import com.lycanitesmobs.core.renderer.RenderCreature;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureEffect;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelShade
extends ModelTemplateBiped {
    public ModelShade() {
        this(1.0f);
    }

    public ModelShade(float shadowSize) {
        this.initModel("shade", LycanitesMobs.modInfo, "entity/shade");
        this.lookHeadScaleX = 0.8f;
        this.lookHeadScaleY = 0.8f;
        this.lookNeckScaleX = 0.2f;
        this.lookNeckScaleY = 0.2f;
        this.trophyScale = 0.8f;
        this.trophyOffset = new float[]{0.0f, -0.2f, 0.0f};
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "eyes", true, LayerCreatureEffect.BLEND.ADD.id, true));
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        if (entity instanceof EntityCreatureBase && entity.func_184179_bs() != null) {
            time *= 0.25f;
            distance *= 0.8f;
        }
        super.animatePart(partName, entity, time, distance * 0.5f, loop, lookY, lookX, scale);
        if (partName.equals("mouth")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.2f)) * 0.1f)), 0.0f, 0.0f);
        } else if (partName.contains("tail")) {
            float sine = 0.0f;
            if (partName.equals("tail.002")) {
                sine = 1.0f;
            } else if (partName.equals("tail.003")) {
                sine = 2.0f;
            } else if (partName.equals("tail.004")) {
                sine = 3.0f;
            } else if (partName.equals("tail.005")) {
                sine = 4.0f;
            } else if (partName.equals("tail.006")) {
                sine = 5.0f;
            } else if (partName.equals("tail.007")) {
                sine = 6.0f;
            }
            sine = MathHelper.func_76126_a((float)(sine / 6.0f)) - 0.5f;
            float rotX = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)((loop + time) * 0.1f)) * 0.05f - 0.05f));
            float rotY = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)((loop + time) * sine * 0.1f)) * 0.4f));
            rotY = (float)((double)rotY + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.25f)) * distance));
            this.rotate(rotX, rotY, 0.0f);
        }
    }
}

