/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.model.ModelCreatureObjOld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelLobber
extends ModelCreatureObjOld {
    float maxLeg = 0.0f;

    public ModelLobber() {
        this(1.0f);
    }

    public ModelLobber(float shadowSize) {
        this.initModel("Lobber", LycanitesMobs.modInfo, "entity/lobber");
        this.setPartCenter("head", 0.0f, 3.0f, 0.3f);
        this.setPartCenter("body", 0.0f, 3.0f, 0.3f);
        this.setPartCenter("leftarm", 1.1f, 2.5f, 0.0f);
        this.setPartCenter("rightarm", -1.1f, 2.5f, 0.0f);
        this.setPartCenter("leftleg", 0.8f, 0.9f, 0.0f);
        this.setPartCenter("rightleg", -0.8f, 0.9f, 0.0f);
        this.trophyScale = 0.8f;
        this.trophyOffset = new float[]{0.0f, -0.2f, 0.0f};
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("leftarm")) {
            rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX - Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (partName.equals("rightarm")) {
            rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (entity == null || entity.field_70122_E || entity.func_70090_H()) {
            float walkSwing = 0.6f;
            if (partName.equals("leftarm")) {
                rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 1.0f * distance * 0.5f));
                rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 0.5f * distance * 0.5f));
            }
            if (partName.equals("rightarm")) {
                rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 1.0f * distance * 0.5f));
                rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 0.5f * distance * 0.5f));
            }
            if (partName.equals("leftleg")) {
                rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 1.4f * distance));
            }
            if (partName.equals("rightleg")) {
                rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 1.4f * distance));
            }
        }
        if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).isAttackOnCooldown()) {
            if (partName.equals("leftarm") || partName.equals("rightarm")) {
                rotX -= 65.0f;
            }
            if (partName.equals("leftarm")) {
                rotY -= 20.0f;
            }
            if (partName.equals("rightarm")) {
                rotY += 20.0f;
            }
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }
}

