/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.model.ModelCreatureObjOld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelBarghest
extends ModelCreatureObjOld {
    float maxLeg = 0.0f;

    public ModelBarghest() {
        this(1.0f);
    }

    public ModelBarghest(float shadowSize) {
        this.initModel("barghest", LycanitesMobs.modInfo, "entity/barghest");
        this.setPartCenter("head", 0.0f, 0.9f, 1.0f);
        this.setPartCenter("mouth", 0.0f, 0.82f, 1.4f);
        this.setPartCenter("body", 0.0f, 1.0f, 0.0f);
        this.setPartCenter("legleftfront", 0.27f, 0.9f, 0.6f);
        this.setPartCenter("legrightfront", -0.27f, 0.9f, 0.6f);
        this.setPartCenter("legleftback", 0.34661f, 0.9f, -0.5f);
        this.setPartCenter("legrightback", -0.34661f, 0.9f, -0.5f);
        this.setPartCenter("tail", 0.0f, 1.0f, -1.0f);
        this.trophyScale = 0.8f;
        this.trophyOffset = new float[]{0.0f, -0.2f, 0.0f};
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("mouth")) {
            this.centerPartToPart("mouth", "head");
            if (!this.lockHeadX) {
                this.rotate((float)Math.toDegrees(lookX / 57.295776f), 0.0f, 0.0f);
            }
            if (!this.lockHeadY) {
                this.rotate(0.0f, (float)Math.toDegrees(lookY / 57.295776f), 0.0f);
            }
            this.uncenterPartToPart("mouth", "head");
        }
        if (partName.equals("mouth")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.1f - 0.1f)), 0.0f, 0.0f);
        }
        if (partName.equals("tail")) {
            rotX = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.05f - 0.05f));
            rotY = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f));
        }
        float walkSwing = 0.6f;
        if (partName.equals("legrightfront") || partName.equals("legleftback")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * walkSwing * distance));
        }
        if (partName.equals("legleftfront") || partName.equals("legrightback")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * distance));
        }
        if (entity != null && !entity.field_70122_E && !entity.func_70090_H()) {
            if (partName.equals("legleftback") || partName.equals("legrightback")) {
                rotX += 25.0f;
            }
            if (partName.equals("legleftfront") || partName.equals("legrightfront")) {
                rotX -= 25.0f;
            }
        }
        if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).isAttackOnCooldown() && partName.equals("mouth")) {
            rotX -= 15.0f;
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }

    @Override
    public void childScale(String partName) {
        if (partName.equals("head") || partName.equals("mouth")) {
            this.translate(-(this.getPartCenter(partName)[0] / 2.0f), -(this.getPartCenter(partName)[1] / 2.0f), -(this.getPartCenter(partName)[2] / 2.0f));
        } else {
            super.childScale(partName);
        }
    }
}

