/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.model.template.ModelTemplateElemental;
import com.lycanitesmobs.core.renderer.RenderCreature;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureEffect;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureScrolling;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelBanshee
extends ModelTemplateElemental {
    public ModelBanshee() {
        this(1.0f);
    }

    public ModelBanshee(float shadowSize) {
        this.initModel("banshee", LycanitesMobs.modInfo, "entity/banshee");
        this.trophyScale = 0.8f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "eye", true, LayerCreatureEffect.BLEND.NORMAL.id, true));
        renderer.func_177094_a(new LayerCreatureScrolling(renderer, "hair", false, LayerCreatureEffect.BLEND.NORMAL.id, true, new Vector2f(0.0f, -16.0f)));
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float bob = -MathHelper.func_76126_a((float)(loop * 0.2f)) * 0.15f;
        if (partName.equals("handleft")) {
            this.translate(bob / 4.0f, bob, this.getAttackProgress());
        } else if (partName.equals("handright")) {
            this.translate(-bob / 4.0f, -bob, this.getAttackProgress());
        }
        if (partName.toLowerCase().equals("eyeleft")) {
            this.rotate((float)Math.toDegrees(lookX / 57.295776f), (float)Math.toDegrees((lookY - 15.0f) / 57.295776f), 0.0f);
        } else if (partName.toLowerCase().equals("eyeright")) {
            this.rotate((float)Math.toDegrees(lookX / 57.295776f), (float)Math.toDegrees((lookY + 15.0f) / 57.295776f), 0.0f);
        } else if (partName.equals("hair01")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.2f)) * 0.2f - 0.2f), 0.0f, 0.0f);
        } else if (partName.equals("hair02")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.2f - 0.2f), 0.0f, 0.0f);
        } else if (partName.equals("fingerleft01") || partName.equals("fingerright01")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.2f)) * 0.2f - 0.2f), 0.0f, 0.0f);
        } else if (partName.equals("fingerleft02") || partName.equals("fingerright02")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)((loop + 20.0f) * 0.2f)) * 0.2f - 0.2f), 0.0f, 0.0f);
        } else if (partName.equals("fingerleft03") || partName.equals("fingerright03")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)((loop + 40.0f) * 0.2f)) * 0.2f - 0.2f), 0.0f, 0.0f);
        } else if (partName.equals("fingerleft04") || partName.equals("fingerright04")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)((loop + 60.0f) * 0.2f)) * 0.2f - 0.2f), 0.0f, 0.0f);
        } else if (partName.equals("fingerleft05") || partName.equals("fingerright05")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)((loop + 60.0f) * 0.2f)) * 0.2f + 0.2f), 0.0f, 0.0f);
        }
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (partName.contains("eye")) {
            return layer != null && "eye".equals(layer.name);
        }
        if (partName.contains("hair")) {
            return layer != null && "hair".equals(layer.name);
        }
        return layer == null;
    }

    @Override
    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        return super.getPartColor(partName, entity, layer, trophy, loop);
    }
}

