/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.model.template.ModelTemplateElemental;
import com.lycanitesmobs.core.renderer.RenderCreature;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureEffect;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelAegis
extends ModelTemplateElemental {
    float maxLeg = 0.0f;

    public ModelAegis() {
        this(1.0f);
    }

    public ModelAegis(float shadowSize) {
        this.initModel("aegis", LycanitesMobs.modInfo, "entity/aegis");
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "", true, LayerCreatureEffect.BLEND.NORMAL.id, true));
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        EntityCreatureBase entityCreature;
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (partName.contains("shieldupper")) {
            this.shiftOrigin(partName, "body");
            this.rotate(0.0f, loop * 8.0f, 0.0f);
            this.shiftOriginBack(partName, "body");
        }
        if (entity instanceof EntityCreatureBase && !(entityCreature = (EntityCreatureBase)entity).isBlocking()) {
            if (partName.equals("core")) {
                // empty if block
            }
            if (partName.contains("shieldupper")) {
                float orbit = loop * 16.0f;
                if (partName.contains("left")) {
                    orbit += 90.0f;
                }
                this.shiftOrigin(partName, "body");
                this.rotate(0.0f, orbit, 0.0f);
                this.shiftOriginBack(partName, "body");
                this.translate(0.0f, -0.25f, 0.0f);
                this.scale(0.5f, 1.0f, 1.0f);
                if ("shieldupperleft01".equals(partName) || "shieldupperright01".equals(partName)) {
                    this.rotate(-90.0f, 0.0f, 0.0f);
                } else if ("shieldupperleft02".equals(partName) || "shieldupperright02".equals(partName)) {
                    this.rotate(90.0f, 0.0f, 0.0f);
                }
            }
            if (partName.contains("shieldlower")) {
                this.scale(0.5f, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (!this.isArmorPart(partName)) {
            float glowSpeed = 40.0f;
            float glow = loop * glowSpeed % 360.0f;
            float color = (float)Math.cos(Math.toRadians(glow)) * 0.1f + 0.9f;
            return new Vector4f(color, color, color, 1.0f);
        }
        return super.getPartColor(partName, entity, layer, trophy, loop);
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (this.isArmorPart(partName)) {
            return layer == null;
        }
        return layer instanceof LayerCreatureEffect;
    }

    protected boolean isArmorPart(String partName) {
        return "shoulders".equals(partName) || "helm".equals(partName) || partName.contains("shield");
    }
}

