/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model;

import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.renderer.RenderProjectileModel;
import com.lycanitesmobs.core.renderer.layer.LayerProjectileBase;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class ModelProjectileBase
extends EntityModel<EntityProjectileBase> {
    public ModelProjectileBase() {
        this(1.0f);
    }

    public ModelProjectileBase(float shadowSize) {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
    }

    public void addCustomLayers(RenderProjectileModel renderer) {
    }

    public void render(EntityProjectileBase entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        this.render(entity, time, distance, loop, lookY, lookX, scale, null, true);
    }

    public void render(EntityProjectileBase entity, float time, float distance, float loop, float lookY, float lookX, float scale, LayerProjectileBase layer, boolean animate) {
        float sizeScale = 1.0f;
        if (entity != null) {
            sizeScale *= entity.getProjectileScale();
        }
        GL11.glScalef((float)sizeScale, (float)sizeScale, (float)sizeScale);
        GL11.glTranslatef((float)0.0f, (float)(0.5f - sizeScale / 2.0f), (float)0.0f);
    }

    public boolean canRenderPart(String partName, EntityProjectileBase entity, LayerProjectileBase layer, boolean trophy) {
        if (layer == null) {
            return this.canBaseRenderPart(partName, entity, trophy);
        }
        if (entity != null) {
            return layer.canRenderPart(partName, entity, trophy);
        }
        return false;
    }

    public boolean canBaseRenderPart(String partName, EntityProjectileBase entity, boolean trophy) {
        return true;
    }

    public Vector4f getPartColor(String partName, EntityProjectileBase entity, LayerProjectileBase layer, boolean trophy, float loop) {
        if (layer == null || entity == null) {
            return this.getBasePartColor(partName, entity, trophy, loop);
        }
        return layer.getPartColor(partName, entity, trophy);
    }

    public Vector4f getBasePartColor(String partName, EntityProjectileBase entity, boolean trophy, float loop) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Vector2f getPartTextureOffset(String partName, EntityProjectileBase entity, LayerProjectileBase layer, boolean trophy, float loop) {
        if (layer == null || !(entity instanceof EntityProjectileBase)) {
            return this.getBaseTextureOffset(partName, entity, trophy, loop);
        }
        return layer.getTextureOffset(partName, entity, trophy, loop);
    }

    public Vector2f getBaseTextureOffset(String partName, EntityProjectileBase entity, boolean trophy, float loop) {
        return new Vector2f(0.0f, 0.0f);
    }
}

