/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.model.ModelCreatureBase;
import com.lycanitesmobs.core.modelloader.obj.ObjObject;
import com.lycanitesmobs.core.modelloader.obj.TessellatorModel;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureBase;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class ModelCreatureObjOld
extends ModelCreatureBase {
    public static float modelXRotOffset = 180.0f;
    public static float modelYPosOffset = -1.5f;
    public TessellatorModel wavefrontObject;
    public List<ObjObject> wavefrontParts;
    public Map<String, float[]> partCenters = new HashMap<String, float[]>();
    public Map<String, float[]> partSubCenters = new HashMap<String, float[]>();
    public Map<String, float[]> offsets = new HashMap<String, float[]>();
    public boolean lockHeadX = false;
    public boolean lockHeadY = false;
    public boolean bodyIsTrophy = true;
    public float trophyScale = 1.0f;
    public float[] trophyOffset = new float[0];
    public float[] trophyMouthOffset = new float[0];
    public boolean dontColor = false;

    public ModelCreatureObjOld() {
        this(1.0f);
    }

    public ModelCreatureObjOld(float shadowSize) {
    }

    public ModelCreatureObjOld initModel(String name, ModInfo groupInfo, String path) {
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(name);
        if (creatureInfo != null && !creatureInfo.enabled) {
            return this;
        }
        this.wavefrontObject = new TessellatorModel(new ResourceLocation(groupInfo.modid, "models/" + path + ".obj"));
        this.wavefrontParts = this.wavefrontObject.objObjects;
        if (this.wavefrontParts.isEmpty()) {
            LycanitesMobs.logWarning("", "Unable to load (old format) model obj for: " + name + "");
        }
        return this;
    }

    @Override
    public void render(EntityCreatureBase entity, float time, float distance, float loop, float lookY, float lookX, float scale, LayerCreatureBase layer, boolean animate) {
        boolean isChild = false;
        boolean trophyModel = false;
        if (scale < 0.0f) {
            trophyModel = true;
            scale = -scale;
        } else {
            scale *= 16.0f;
            if (entity != null) {
                scale *= entity.func_213355_cm();
            }
        }
        if (entity != null && entity.onlyRenderTicks >= 0.0f) {
            loop = entity.onlyRenderTicks;
        }
        for (ObjObject part : this.wavefrontParts) {
            if (part.getName() == null) continue;
            String partName = part.getName().toLowerCase();
            boolean isTrophyPart = this.isTrophyPart(partName);
            if (this.bodyIsTrophy && partName.contains("body")) {
                isTrophyPart = true;
            }
            if (!this.canRenderPart(partName, (Entity)entity, layer, trophyModel) || trophyModel && !isTrophyPart) continue;
            GlStateManager.pushMatrix();
            GlStateManager.enableAlphaTest();
            this.rotate(modelXRotOffset, 1.0f, 0.0f, 0.0f);
            this.translate(0.0f, modelYPosOffset, 0.0f);
            if (isChild && !trophyModel) {
                this.childScale(partName);
            }
            this.scale(scale, scale, scale);
            if (trophyModel) {
                this.scale(this.trophyScale, this.trophyScale, this.trophyScale);
            }
            this.centerPart(partName);
            this.animatePart(partName, (LivingEntity)entity, time, distance, loop, -lookY, lookX, scale);
            if (trophyModel) {
                if (!partName.contains("head") && !partName.contains("body")) {
                    float[] mouthOffset = this.comparePartCenters(this.bodyIsTrophy ? "body" : "head", partName);
                    this.translate(mouthOffset[0], mouthOffset[1], mouthOffset[2]);
                    if (this.trophyMouthOffset.length >= 3) {
                        this.translate(this.trophyMouthOffset[0], this.trophyMouthOffset[1], this.trophyMouthOffset[2]);
                    }
                }
                if (partName.contains("head")) {
                    if (!partName.contains("left")) {
                        this.translate(-0.3f, 0.0f, 0.0f);
                        this.rotate(5.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (!partName.contains("right")) {
                        this.translate(0.3f, 0.0f, 0.0f);
                        this.rotate(-5.0f, 0.0f, 1.0f, 0.0f);
                    }
                }
                this.uncenterPart(partName);
                if (this.trophyOffset.length >= 3) {
                    this.translate(this.trophyOffset[0], this.trophyOffset[1], this.trophyOffset[2]);
                }
            }
            this.uncenterPart(partName);
            this.onRenderStart(layer, (Entity)entity, trophyModel);
            this.wavefrontObject.renderGroup(part, this.getPartColor(partName, (Entity)entity, layer, trophyModel, loop), this.getPartTextureOffset(partName, (Entity)entity, layer, trophyModel, loop));
            this.onRenderFinish(layer, (Entity)entity, trophyModel);
            GlStateManager.popMatrix();
        }
    }

    public void onRenderStart(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        if (!CreatureManager.getInstance().config.disableModelAlpha) {
            GlStateManager.enableBlend();
        }
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (layer != null) {
            layer.onRenderStart(entity, renderAsTrophy);
        }
    }

    public void onRenderFinish(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        if (!CreatureManager.getInstance().config.disableModelAlpha) {
            GlStateManager.disableBlend();
        }
        if (layer != null) {
            layer.onRenderFinish(entity, renderAsTrophy);
        }
    }

    public boolean isTrophyPart(String partName) {
        if (partName == null) {
            return false;
        }
        return (partName = partName.toLowerCase()).contains("head") || partName.contains("mouth") || partName.contains("eye");
    }

    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.toLowerCase().contains("head")) {
            if (!this.lockHeadX) {
                rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f));
            }
            if (!this.lockHeadY) {
                rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f));
            }
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }

    public void childScale(String partName) {
        this.scale(0.5f, 0.5f, 0.5f);
    }

    public void rotate(float rotX, float rotY, float rotZ) {
        GL11.glRotatef((float)rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public void rotate(float rotation, float angleX, float angleY, float angleZ) {
        GL11.glRotatef((float)rotation, (float)angleX, (float)angleY, (float)angleZ);
    }

    public void translate(float posX, float posY, float posZ) {
        GL11.glTranslatef((float)posX, (float)posY, (float)posZ);
    }

    public void scale(float scaleX, float scaleY, float scaleZ) {
        GL11.glScalef((float)scaleX, (float)scaleY, (float)scaleZ);
    }

    public void setPartCenter(String partName, float centerX, float centerY, float centerZ) {
        if (this.isTrophyPart(partName)) {
            this.bodyIsTrophy = false;
        }
        this.partCenters.put(partName, new float[]{centerX, centerY, centerZ});
    }

    public void setPartCenters(float centerX, float centerY, float centerZ, String ... partNames) {
        for (String partName : partNames) {
            this.setPartCenter(partName, centerX, centerY, centerZ);
        }
    }

    public float[] getPartCenter(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.partCenters.get(partName);
    }

    public void centerPart(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return;
        }
        float[] partCenter = this.partCenters.get(partName);
        this.translate(partCenter[0], partCenter[1], partCenter[2]);
    }

    public void uncenterPart(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return;
        }
        float[] partCenter = this.partCenters.get(partName);
        this.translate(-partCenter[0], -partCenter[1], -partCenter[2]);
    }

    public void centerPartToPart(String part, String targetPart) {
        this.uncenterPart(part);
        float[] partCenter = this.partCenters.get(targetPart);
        if (partCenter != null) {
            this.translate(partCenter[0], partCenter[1], partCenter[2]);
        }
    }

    public void uncenterPartToPart(String part, String targetPart) {
        float[] partCenter = this.partCenters.get(targetPart);
        if (partCenter != null) {
            this.translate(-partCenter[0], -partCenter[1], -partCenter[2]);
        }
        this.centerPart(part);
    }

    public float[] comparePartCenters(String centerPartName, String targetPartName) {
        float[] centerPart = this.getPartCenter(centerPartName);
        float[] targetPart = this.getPartCenter(targetPartName);
        float[] partDifference = new float[3];
        if (targetPart == null) {
            return partDifference;
        }
        for (int i = 0; i < 3; ++i) {
            partDifference[i] = targetPart[i] - centerPart[i];
        }
        return partDifference;
    }

    public void setPartSubCenter(String partName, float centerX, float centerY, float centerZ) {
        this.partSubCenters.put(partName, new float[]{centerX, centerY, centerZ});
    }

    public void setPartSubCenters(float centerX, float centerY, float centerZ, String ... partNames) {
        for (String partName : partNames) {
            this.setPartSubCenter(partName, centerX, centerY, centerZ);
        }
    }

    public void subCenterPart(String partName) {
        float[] offset = this.getSubCenterOffset(partName);
        if (offset == null) {
            return;
        }
        this.translate(offset[0], offset[1], offset[2]);
    }

    public void unsubCenterPart(String partName) {
        float[] offset = this.getSubCenterOffset(partName);
        if (offset == null) {
            return;
        }
        this.translate(-offset[0], -offset[1], -offset[2]);
    }

    public float[] getSubCenterOffset(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return null;
        }
        if (!this.partSubCenters.containsKey(partName)) {
            return null;
        }
        float[] partCenter = this.partCenters.get(partName);
        float[] partSubCenter = this.partSubCenters.get(partName);
        float[] offset = new float[3];
        for (int coord = 0; coord < 3; ++coord) {
            offset[coord] = partSubCenter[coord] - partCenter[coord];
        }
        return offset;
    }

    public void setOffset(String offsetName, float[] offset) {
        this.offsets.put(offsetName, offset);
    }

    public float[] getOffset(String offsetName) {
        if (!this.offsets.containsKey(offsetName)) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.offsets.get(offsetName);
    }

    public double rotateToPoint(double aTarget, double bTarget) {
        return this.rotateToPoint(0.0, 0.0, aTarget, bTarget);
    }

    public double rotateToPoint(double aCenter, double bCenter, double aTarget, double bTarget) {
        if (aTarget - aCenter == 0.0) {
            if (aTarget > aCenter) {
                return 0.0;
            }
            if (aTarget < aCenter) {
                return 180.0;
            }
        }
        if (bTarget - bCenter == 0.0) {
            if (bTarget > bCenter) {
                return 90.0;
            }
            if (bTarget < bCenter) {
                return -90.0;
            }
        }
        if (aTarget - aCenter == 0.0 && bTarget - bCenter == 0.0) {
            return 0.0;
        }
        return Math.toDegrees(Math.atan2(aCenter - aTarget, bCenter - bTarget) - 1.5707963267948966);
    }

    public double[] rotateToPoint(double xCenter, double yCenter, double zCenter, double xTarget, double yTarget, double zTarget) {
        double[] rotations = new double[]{this.rotateToPoint(yCenter, -zCenter, yTarget, -zTarget), this.rotateToPoint(-zCenter, xCenter, -zTarget, xTarget), this.rotateToPoint(yCenter, xCenter, yTarget, xTarget)};
        return rotations;
    }
}

