/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model;

import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.renderer.RenderCreature;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.core.renderer.layer.LayerCreatureSaddle;
import com.lycanitesmobs.core.renderer.layer.LayerEquipment;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class ModelCreatureBase
extends EntityModel<EntityCreatureBase> {
    public ModelCreatureBase() {
        this(1.0f);
    }

    public ModelCreatureBase(float shadowSize) {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
    }

    public void addCustomLayers(RenderCreature renderer) {
        renderer.func_177094_a(new LayerEquipment(renderer, "chest"));
        renderer.func_177094_a(new LayerCreatureSaddle(renderer));
    }

    public void render(EntityCreatureBase entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        this.render(entity, time, distance, loop, lookY, lookX, scale, null, true);
    }

    public void render(EntityCreatureBase entity, float time, float distance, float loop, float lookY, float lookX, float scale, LayerCreatureBase layer, boolean animate) {
        float sizeScale = 1.0f;
        if (entity != null) {
            sizeScale *= entity.func_213355_cm();
        }
        GL11.glScalef((float)sizeScale, (float)sizeScale, (float)sizeScale);
        GL11.glTranslatef((float)0.0f, (float)(0.5f - sizeScale / 2.0f), (float)0.0f);
    }

    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (layer == null) {
            return this.canBaseRenderPart(partName, entity, trophy);
        }
        if (entity instanceof EntityCreatureBase) {
            return layer.canRenderPart(partName, (EntityCreatureBase)entity, trophy);
        }
        return false;
    }

    public boolean canBaseRenderPart(String partName, Entity entity, boolean trophy) {
        return true;
    }

    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (layer == null || !(entity instanceof EntityCreatureBase)) {
            return this.getBasePartColor(partName, entity, trophy, loop);
        }
        return layer.getPartColor(partName, (EntityCreatureBase)entity, trophy);
    }

    public Vector4f getBasePartColor(String partName, Entity entity, boolean trophy, float loop) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Vector2f getPartTextureOffset(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (layer == null || !(entity instanceof EntityCreatureBase)) {
            return this.getBaseTextureOffset(partName, entity, trophy, loop);
        }
        return layer.getTextureOffset(partName, (EntityCreatureBase)entity, trophy, loop);
    }

    public Vector2f getBaseTextureOffset(String partName, Entity entity, boolean trophy, float loop) {
        return new Vector2f(0.0f, 0.0f);
    }
}

